/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.gif.GIFNeuralColorMap;
import org.freehep.graphicsio.gif.ImageEncoder;

public class GIFEncoder
extends ImageEncoder {
    private boolean interlace = false;
    private String comment = null;
    int width;
    int height;
    int[][] rgbPixels;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GIFEncoder(Image img, OutputStream out) throws IOException {
        this(img, out, false);
    }

    public GIFEncoder(Image img, DataOutput dos) throws IOException {
        this(img, dos, false);
    }

    public GIFEncoder(Image img, OutputStream out, boolean interlace) throws IOException {
        this(img, (DataOutput)new DataOutputStream(out), interlace);
    }

    public GIFEncoder(Image img, DataOutput dos, boolean interlace) throws IOException {
        super(img, dos);
        this.interlace = interlace;
    }

    public GIFEncoder(ImageProducer prod, OutputStream out) throws IOException {
        this(prod, out, false);
    }

    public GIFEncoder(ImageProducer prod, DataOutput dos) throws IOException {
        this(prod, dos, false);
    }

    public GIFEncoder(ImageProducer prod, OutputStream out, boolean interlace) throws IOException {
        this(prod, (DataOutput)new DataOutputStream(out), interlace);
    }

    public GIFEncoder(ImageProducer prod, DataOutput dos, boolean interlace) throws IOException {
        super(prod, dos);
        this.interlace = interlace;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    protected void encodeStart(int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        this.rgbPixels = new int[height][width];
    }

    @Override
    protected void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        for (int row = 0; row < h; ++row) {
            System.arraycopy(rgbPixels, row * scansize + off, this.rgbPixels[y + row], x, w);
        }
    }

    @Override
    protected void encodeDone() throws IOException {
        int nColors;
        GIFNeuralColorMap colorMap = new GIFNeuralColorMap();
        int[] palette = colorMap.create(this.rgbPixels, 255);
        int transparentIndex = -1;
        for (int i = 0; i < palette.length; ++i) {
            if ((palette[i] & 0xFF000000) != 0) continue;
            transparentIndex = i;
            break;
        }
        int logColors = (nColors = palette.length) <= 2 ? 1 : (nColors <= 4 ? 2 : (nColors <= 16 ? 4 : 8));
        this.GIFEncode(this.width, this.height, this.interlace, (byte)0, transparentIndex, logColors, palette);
    }

    byte GetPixel(int x, int y) throws IOException {
        return (byte)this.rgbPixels[y][x];
    }

    void writeString(String str) throws IOException {
        byte[] buf = str.getBytes();
        this.out.write(buf);
    }

    void GIFEncode(int Width, int Height, boolean Interlace, byte Background, int Transparent, int BitsPerPixel, int[] palette) throws IOException {
        this.Width = Width;
        this.Height = Height;
        this.Interlace = Interlace;
        int TopOfs = 0;
        int LeftOfs = 0;
        this.CountDown = Width * Height;
        this.Pass = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        this.curx = 0;
        this.cury = 0;
        this.writeString("GIF89a");
        this.Putword(Width);
        this.Putword(Height);
        byte B2 = -128;
        B2 = (byte)(B2 | 0x70);
        B2 = (byte)(B2 | (byte)(BitsPerPixel - 1));
        this.Putbyte(B2);
        this.Putbyte(Background);
        this.Putbyte((byte)0);
        int colorMapSize = 1 << BitsPerPixel;
        for (int i = 0; i < colorMapSize; ++i) {
            if (i < palette.length) {
                this.Putbyte((byte)(palette[i] >> 16 & 0xFF));
                this.Putbyte((byte)(palette[i] >> 8 & 0xFF));
                this.Putbyte((byte)(palette[i] & 0xFF));
                continue;
            }
            this.Putbyte((byte)0);
            this.Putbyte((byte)0);
            this.Putbyte((byte)0);
        }
        if (Transparent != -1) {
            this.Putbyte((byte)33);
            this.Putbyte((byte)-7);
            this.Putbyte((byte)4);
            this.Putbyte((byte)1);
            this.Putbyte((byte)0);
            this.Putbyte((byte)0);
            this.Putbyte((byte)Transparent);
            this.Putbyte((byte)0);
        }
        this.Putbyte((byte)44);
        this.Putword(LeftOfs);
        this.Putword(TopOfs);
        this.Putword(Width);
        this.Putword(Height);
        if (Interlace) {
            this.Putbyte((byte)64);
        } else {
            this.Putbyte((byte)0);
        }
        this.Putbyte((byte)InitCodeSize);
        this.compress(InitCodeSize + 1);
        this.Putbyte((byte)0);
        if (this.comment != null && this.comment.length() > 0) {
            this.Putbyte((byte)33);
            this.Putbyte((byte)-2);
            this.Putbyte((byte)this.comment.length());
            this.writeString(this.comment);
            this.Putbyte((byte)0);
        }
        this.Putbyte((byte)59);
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte r = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return r & 0xFF;
    }

    void Putword(int w) throws IOException {
        this.Putbyte((byte)(w & 0xFF));
        this.Putbyte((byte)(w >> 8 & 0xFF));
    }

    void Putbyte(byte b) throws IOException {
        this.out.write(b);
    }

    final int MAXCODE(int n_bits) {
        return (1 << n_bits) - 1;
    }

    void compress(int init_bits) throws IOException {
        int c;
        int fcode;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int ent = this.GIFNextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.ClearCode);
        block1: while ((c = this.GIFNextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block();
        }
        this.output(ent);
        this.output(this.EOFCode);
    }

    void output(int code) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF));
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (code == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF));
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char();
        }
    }

    void cl_block() throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode);
    }

    void cl_hash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte c) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char();
        }
    }

    void flush_char() throws IOException {
        if (this.a_count > 0) {
            this.out.write(this.a_count);
            this.out.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

