/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class LineWidthSpecificationMode
extends CGMTag {
    public static final int ABSOLUTE = 0;
    public static final int SCALED = 1;
    public static final int FRACTIONAL = 2;
    public static final int MM = 3;
    private int mode;

    public LineWidthSpecificationMode() {
        super(2, 3, 1);
    }

    public LineWidthSpecificationMode(int mode) {
        this();
        this.mode = mode;
    }

    @Override
    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.setLineWidthSpecificationMode(this.mode);
        cgm.writeEnumerate(this.mode);
    }

    @Override
    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.setLineWidthSpecificationMode(this.mode);
        cgm.print("LINEWIDTHMODE ");
        switch (this.mode) {
            default: {
                cgm.print("ABS");
                break;
            }
            case 1: {
                cgm.print("SCALED");
                break;
            }
            case 2: {
                cgm.print("FRACTIONAL");
                break;
            }
            case 3: {
                cgm.print("METRIC");
            }
        }
    }
}

