/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import org.freehep.aid.JNITypeConversion;
import org.freehep.aid.JNITypeConverter;
import org.freehep.rtti.IType;

public class StringToString
extends JNITypeConversion {
    public StringToString(String indent, String cr) {
        super(indent, cr);
    }

    @Override
    public String convertToJava(JNITypeConverter converter, int scope, IType type, int dimension, String nameSpace, String src, String dst) {
        StringBuffer s = new StringBuffer();
        s.append(this.indent(scope));
        s.append("// converting string to String");
        s.append(this.cr);
        s.append(this.indent(scope));
        s.append(dst);
        s.append(" = env->NewStringUTF(");
        s.append(src);
        s.append(".c_str());");
        s.append(this.cr);
        return s.toString();
    }

    public String cleanJava(int scope, IType type, int dimension, String nameSpace, String src, String dst) {
        StringBuffer s = new StringBuffer();
        s.append(this.indent(scope));
        s.append("// free String");
        s.append(this.cr);
        s.append(this.indent(scope));
        s.append("env->DeleteLocalRef(");
        s.append(dst);
        s.append(");");
        s.append(this.cr);
        return s.toString();
    }

    @Override
    public String convertToCPP(JNITypeConverter converter, int scope, IType type, int dimension, String nameSpace, String src, String dst) {
        StringBuffer s = new StringBuffer();
        s.append(this.indent(scope));
        s.append("// converting String to string");
        s.append(this.cr);
        s.append(this.indent(scope));
        s.append("jboolean isCopy");
        s.append(scope);
        s.append(";");
        s.append(this.cr);
        s.append(this.indent(scope));
        s.append(dst);
        s.append(" = env->GetStringUTFChars(");
        s.append(src);
        s.append(", &isCopy");
        s.append(scope);
        s.append(");");
        s.append(this.cr);
        return s.toString();
    }

    public String cleanCPP(int scope, IType type, int dimension, String nameSpace, String src, String dst) {
        StringBuffer s = new StringBuffer();
        s.append(this.indent(scope));
        s.append("// free string");
        s.append(this.cr);
        s.append(this.indent(scope));
        s.append("if (isCopy");
        s.append(scope);
        s.append(" == JNI_TRUE) {");
        s.append(this.cr);
        s.append(this.indent(scope + 1));
        s.append("env->ReleaseStringUTFChars(");
        s.append(src);
        s.append(", ");
        s.append(dst);
        s.append(");");
        s.append(this.cr);
        s.append(this.indent(scope));
        s.append("}");
        s.append(this.cr);
        return s.toString();
    }
}

