/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.freehep.aid.CPPTypeConverter;
import org.freehep.aid.ColorToDoubleVector;
import org.freehep.aid.JNITypeConversion;
import org.freehep.aid.ObjectArrayToObjectVector;
import org.freehep.aid.ObjectCollectionToObjectVector;
import org.freehep.aid.PrimitiveArrayToPrimitiveVector;
import org.freehep.aid.PrimitiveToPrimitive;
import org.freehep.aid.StringToString;
import org.freehep.rtti.IType;

public class JNITypeConverter
extends CPPTypeConverter {
    protected Map types = new HashMap();
    protected String cr;
    protected Properties jniProperties = new Properties();

    public JNITypeConverter(String propDir, String indent, String cr) {
        super(propDir);
        this.cr = cr;
        String name = "aid.jni.cpp.properties";
        try {
            this.jniProperties.load(this.getClass().getResourceAsStream(name));
        }
        catch (IOException ioe) {
            System.err.println(this.getClass().getName() + ": Unable to load property file " + name);
        }
        this.types.put("Color", new ColorToDoubleVector(indent, cr));
        this.types.put("Collection", new ObjectCollectionToObjectVector(indent, cr));
        this.types.put("Object[]", new ObjectArrayToObjectVector(indent, cr));
        this.types.put("String", new StringToString(indent, cr));
        this.types.put("primitive", new PrimitiveToPrimitive(indent, cr));
        this.types.put("primitive[]", new PrimitiveArrayToPrimitiveVector(indent, cr));
    }

    public String convertToJava(int scope, IType type, int dimension, String nameSpace, String src, String dst) {
        JNITypeConversion conversion = this.getConversion(type, dimension);
        if (conversion != null) {
            return conversion.convertToJava(this, scope, type, dimension, nameSpace, src, dst);
        }
        return "// WARNING no conversion for " + type + this.cr;
    }

    public String convertToCPP(int scope, IType type, int dimension, String nameSpace, String src, String dst) {
        JNITypeConversion conversion = this.getConversion(type, dimension);
        if (conversion != null) {
            return conversion.convertToCPP(this, scope, type, dimension, nameSpace, src, dst);
        }
        return "// WARNING no conversion for " + type + this.cr;
    }

    protected JNITypeConversion getConversion(IType type, int dimension) {
        String typeName = type.getName();
        switch (dimension) {
            case 0: {
                if (type.isPrimitive()) {
                    return (JNITypeConversion)this.types.get("primitive");
                }
                return (JNITypeConversion)this.types.get(typeName);
            }
            case 1: {
                if (type.isPrimitive()) {
                    return (JNITypeConversion)this.types.get("primitive[]");
                }
                return (JNITypeConversion)this.types.get("Object[]");
            }
        }
        return (JNITypeConversion)this.types.get("Object[]");
    }

    public String jniCall(IType type) {
        return this.jniCall(type, type.getDimension());
    }

    public String jniCall(IType type, int dimension) {
        if (type.isPrimitive() && dimension == 0) {
            return Character.toUpperCase(type.getName().charAt(0)) + type.getName().substring(1);
        }
        return "Object";
    }

    public String jniType(IType type) {
        return this.jniType(type, type.getDimension());
    }

    public String jniType(IType type, int dimension) {
        String jniType = this.jniProperties.getProperty(type.getName(), "jobject");
        switch (dimension) {
            case 0: {
                return jniType;
            }
            case 1: {
                return jniType.equals("jstring") ? "jobjectArray" : jniType + "Array";
            }
        }
        return "jobjectArray";
    }
}

