/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.matrix;

import hep.physics.matrix.Matrix;
import hep.physics.matrix.MatrixOp;
import hep.physics.matrix.MutableMatrix;
import java.io.Serializable;

public class BasicMatrix
implements MutableMatrix,
Serializable {
    static final long serialVersionUID = -3491275185124557222L;
    private double[][] data;

    public BasicMatrix(int nRows, int nCols) {
        this.data = new double[nRows][nCols];
    }

    public BasicMatrix(double[][] data) {
        if (data.length <= 0) {
            throw new IllegalArgumentException("Invalid data");
        }
        int nCols = data[0].length;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length > 0 && data[i].length == nCols) continue;
            throw new IllegalArgumentException("Invalid data");
        }
        this.data = data;
    }

    public BasicMatrix(Matrix mIn) {
        int nRows = mIn.getNRows();
        int nCols = mIn.getNColumns();
        this.data = new double[nRows][nCols];
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                this.data[i][j] = mIn.e(i, j);
            }
        }
    }

    @Override
    public int getNRows() {
        return this.data.length;
    }

    @Override
    public int getNColumns() {
        return this.data[0].length;
    }

    @Override
    public double e(int row, int column) {
        return this.data[row][column];
    }

    public double det() {
        return MatrixOp.det(this);
    }

    public String toString() {
        return MatrixOp.toString(this);
    }

    @Override
    public void setElement(int row, int column, double value) {
        this.data[row][column] = value;
    }

    @Override
    public void invert() throws MatrixOp.IndeterminateMatrixException {
        MatrixOp.inverse(this, this);
    }

    @Override
    public void transpose() {
        MatrixOp.transposed(this, this);
    }
}

