/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.jet;

import hep.physics.filter.Predicate;
import hep.physics.jet.JetFinder;
import hep.physics.vec.BasicHepLorentzVector;
import hep.physics.vec.Hep3Vector;
import hep.physics.vec.HepLorentzVector;
import hep.physics.vec.VecOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractJetFinder
implements JetFinder {
    private double defaultMassSquared = 0.0;
    private static final int UNASSOC = -999;
    private int m_injets;
    private HepLorentzVector[] m_jet;
    private int[] m_ipart_jet_assoc;
    private int[] m_inparts_per_jet;
    private int m_ifewest_tracks;
    private double m_dycut;
    private boolean m_resultsValid = false;
    private List m_in;
    private List m_4vec;
    private double m_devis = 0.0;
    protected int m_np;
    protected HepLorentzVector[] m_part;
    protected double[][] ymass;

    abstract double masscut(double var1, double var3, double var5);

    abstract double calculate_mass(HepLorentzVector var1, HepLorentzVector var2);

    abstract void combine_particles(int var1, int var2);

    @Override
    public int njets() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_injets;
    }

    @Override
    public HepLorentzVector jet(int index) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jet[index];
    }

    @Override
    public List particlesInJet(int index) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.m_ipart_jet_assoc.length; ++i) {
            if (this.m_ipart_jet_assoc[i] != index) continue;
            result.add(this.m_in.get(i));
        }
        return result;
    }

    @Override
    public int nParticlesPerJet(int index) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_inparts_per_jet[index];
    }

    @Override
    public int fewestTracks() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_ifewest_tracks;
    }

    protected AbstractJetFinder(double ycut) {
        this.m_dycut = ycut;
        this.m_resultsValid = false;
    }

    public double getYCut() {
        return this.m_dycut;
    }

    public void setYCut(double ycut) {
        if (this.m_dycut != ycut) {
            this.m_resultsValid = false;
        }
        this.m_dycut = ycut;
    }

    @Override
    public void setEvent(Collection data) {
        this.setEvent(data, null);
    }

    public void setAssumedMassFor3Vectors(double mass) {
        this.defaultMassSquared = mass * mass;
    }

    @Override
    public void setEvent(Collection data, Predicate cut) {
        this.m_resultsValid = false;
        this.m_in = new ArrayList();
        this.m_4vec = new ArrayList();
        this.m_devis = 0.0;
        for (Object o : data) {
            Object in;
            if (cut != null && !cut.accept(o)) continue;
            if (o instanceof HepLorentzVector) {
                in = (HepLorentzVector)o;
                this.m_devis += in.t();
                this.m_in.add(in);
                this.m_4vec.add(in);
                continue;
            }
            if (o instanceof Hep3Vector) {
                in = (Hep3Vector)o;
                double energy = Math.sqrt(in.magnitudeSquared() + this.defaultMassSquared);
                this.m_devis += energy;
                this.m_in.add(in);
                this.m_4vec.add(new BasicHepLorentzVector(energy, (Hep3Vector)in));
                continue;
            }
            throw new IllegalArgumentException("Element input to JetFinder is not a IHep3Vector or an IHepLorentzVector");
        }
        this.m_np = this.m_4vec.size();
        this.m_part = new HepLorentzVector[this.m_np];
    }

    private void doFindJets() {
        int i;
        this.m_resultsValid = true;
        this.m_injets = 0;
        if (this.m_np < 2) {
            return;
        }
        this.m_ipart_jet_assoc = new int[this.m_np];
        for (int m = 0; m < this.m_np; ++m) {
            this.m_ipart_jet_assoc[m] = -999;
        }
        this.m_4vec.toArray(this.m_part);
        double esum = this.m_devis;
        this.ymass = new double[this.m_np][this.m_np];
        for (i = 0; i < this.m_np - 1; ++i) {
            for (int j = i + 1; j < this.m_np; ++j) {
                double cmass = this.calculate_mass(this.m_part[i], this.m_part[j]);
                this.ymass[i][j] = cmass != -9999.0 ? cmass : 0.0;
            }
        }
        block3: while (true) {
            int j;
            int im = -1;
            int jm = -1;
            double minmass = Double.MAX_VALUE;
            for (int i2 = 0; i2 < this.m_np - 1; ++i2) {
                if (this.m_ipart_jet_assoc[i2] != -999) continue;
                for (int j2 = i2 + 1; j2 < this.m_np; ++j2) {
                    if (this.m_ipart_jet_assoc[j2] != -999 || !(this.ymass[i2][j2] < minmass)) continue;
                    minmass = this.ymass[i2][j2];
                    im = i2;
                    jm = j2;
                }
            }
            if (minmass > this.masscut(this.m_dycut, this.m_devis, esum)) break;
            this.combine_particles(im, jm);
            this.m_ipart_jet_assoc[jm] = im;
            for (j = 0; j < this.m_np; ++j) {
                if (this.m_ipart_jet_assoc[j] != jm) continue;
                this.m_ipart_jet_assoc[j] = im;
            }
            esum = 0.0;
            j = 0;
            while (true) {
                if (j >= this.m_np) continue block3;
                if (this.m_ipart_jet_assoc[j] == -999) {
                    int imax;
                    int imin;
                    double cmass;
                    esum += this.m_part[j].t();
                    if (j != im && (cmass = this.calculate_mass(this.m_part[imin = Math.min(j, im)], this.m_part[imax = Math.max(j, im)])) >= 0.0) {
                        this.ymass[imin][imax] = cmass;
                    }
                }
                ++j;
            }
            break;
        }
        for (i = 0; i < this.m_np; ++i) {
            if (this.m_ipart_jet_assoc[i] != -999) continue;
            ++this.m_injets;
        }
        this.m_jet = new HepLorentzVector[this.m_injets];
        this.m_inparts_per_jet = new int[this.m_injets];
        int nj = 0;
        this.m_ifewest_tracks = Integer.MAX_VALUE;
        for (int i3 = 0; i3 < this.m_np; ++i3) {
            if (this.m_ipart_jet_assoc[i3] != -999) continue;
            this.m_jet[nj] = this.m_part[i3];
            int ntrk = 1;
            for (int j = 0; j < this.m_np; ++j) {
                if (this.m_ipart_jet_assoc[j] != i3) continue;
                this.m_ipart_jet_assoc[j] = nj;
                ++ntrk;
            }
            this.m_ipart_jet_assoc[i3] = nj;
            this.m_inparts_per_jet[nj] = ntrk;
            if (ntrk < this.m_ifewest_tracks) {
                this.m_ifewest_tracks = ntrk;
            }
            ++nj;
        }
    }

    protected double standard_masscut(double ycut, double evis) {
        return ycut * evis * evis;
    }

    protected double geneva_masscut(double ycut) {
        return ycut;
    }

    protected double jadeP0_masscut(double ycut, double esum) {
        return ycut * esum * esum;
    }

    protected void four_vector_combine(int im, int jm) {
        this.m_part[im] = VecOp.add(this.m_part[im], this.m_part[jm]);
    }

    protected void jadeP_combine(int im, int jm) {
        Hep3Vector v = VecOp.add(this.m_part[im].v3(), this.m_part[jm].v3());
        this.m_part[im] = new BasicHepLorentzVector(v.magnitude(), v);
    }

    protected void jadeE0_combine(int im, int jm) {
        HepLorentzVector v = VecOp.add(this.m_part[im], this.m_part[jm]);
        double ekeratio = v.t() / v.v3().magnitude();
        this.m_part[im] = new BasicHepLorentzVector(v.t(), VecOp.mult(ekeratio, this.m_part[im].v3()));
    }

    protected double four_vector_mass(HepLorentzVector part1, HepLorentzVector part2) {
        return VecOp.add(part1, part2).magnitudeSquared();
    }

    protected double jade_mass(HepLorentzVector part1, HepLorentzVector part2) {
        double e1 = part1.t();
        double e2 = part2.t();
        Hep3Vector v1 = part1.v3();
        Hep3Vector v2 = part2.v3();
        double costh = VecOp.dot(v1, v2) / (v1.magnitude() * v2.magnitude());
        return 2.0 * e1 * e2 * (1.0 - costh);
    }

    protected double durham_mass(HepLorentzVector part1, HepLorentzVector part2) {
        double e1 = part1.t();
        double e2 = part2.t();
        Hep3Vector v1 = part1.v3();
        Hep3Vector v2 = part2.v3();
        double costh = VecOp.dot(v1, v2) / (v1.magnitude() * v2.magnitude());
        double lessorE = Math.min(e1, e2);
        return 2.0 * lessorE * lessorE * (1.0 - costh);
    }

    protected double geneva_mass(HepLorentzVector part1, HepLorentzVector part2) {
        double e2;
        double e1 = part1.t();
        if (e1 == 0.0 & (e2 = part2.t()) == 0.0) {
            return -9999.0;
        }
        Hep3Vector v1 = part1.v3();
        Hep3Vector v2 = part2.v3();
        double costh = VecOp.dot(v1, v2) / (v1.magnitude() * v2.magnitude());
        return 0.8888888888888888 * (1.0 - costh) * (e1 * e2) / ((e1 + e2) * (e1 + e2));
    }
}

