/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XDRInputStream
extends DataInputStream
implements XDRDataInput {
    private CountedInputStream cin;
    private static final int SANITY_CHECK = Integer.getInteger("hep.io.xdr.sanityCheck", 100000);

    public XDRInputStream(InputStream in) {
        super(new CountedInputStream(in));
        this.cin = (CountedInputStream)this.in;
    }

    public long getBytesRead() {
        return this.cin.getBytesRead();
    }

    public void setReadLimit(int bytes) {
        this.cin.setReadLimit(bytes);
    }

    public void clearReadLimit() {
        this.cin.clearReadLimit();
    }

    @Override
    public void pad() throws IOException {
        int offset = (int)(this.getBytesRead() % 4L);
        if (offset != 0) {
            this.skipBytes(4 - offset);
        }
    }

    @Override
    public double[] readDoubleArray(double[] buffer) throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("Array length failed sanity check: " + l);
        }
        double[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new double[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readDouble();
        }
        return result;
    }

    @Override
    public float[] readFloatArray(float[] buffer) throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("Array length failed sanity check: " + l);
        }
        float[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new float[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    @Override
    public int[] readIntArray(int[] buffer) throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("Array length failed sanity check: " + l);
        }
        int[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new int[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    @Override
    public String readString(int l) throws IOException {
        byte[] ascii = new byte[l];
        this.readFully(ascii);
        this.pad();
        return new String(ascii, "US-ASCII");
    }

    @Override
    public String readString() throws IOException {
        int l = this.readInt();
        if (l > SANITY_CHECK) {
            throw new IOException("String length failed sanity check: " + l);
        }
        return this.readString(l);
    }

    private static final class CountedInputStream
    extends FilterInputStream {
        private long count = 0L;
        private long limit = -1L;
        private long mark = 0L;

        CountedInputStream(InputStream in) {
            super(in);
        }

        public long getBytesRead() {
            return this.count;
        }

        @Override
        public int available() throws IOException {
            return Math.min((int)(this.limit - this.count), super.available());
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.mark = this.count;
            super.mark(readlimit);
        }

        @Override
        public int read() throws IOException {
            int available = this.checkLimit(1);
            int rc = super.read();
            if (rc >= 0) {
                ++this.count;
            }
            return rc;
        }

        @Override
        public int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        @Override
        public int read(byte[] data, int off, int len) throws IOException {
            int available = this.checkLimit(len);
            int rc = super.read(data, off, available);
            if (rc > 0) {
                this.count += (long)rc;
            }
            return rc;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.count = this.mark;
            super.reset();
        }

        @Override
        public long skip(long bytes) throws IOException {
            long available = this.checkLimit(bytes);
            long rc = super.skip(available);
            if (rc > 0L) {
                this.count += rc;
            }
            return rc;
        }

        void setReadLimit(int bytes) {
            this.limit = this.count + (long)bytes;
        }

        void clearReadLimit() {
            this.limit = -1L;
        }

        private int checkLimit(int request) throws IOException {
            if (this.limit < 0L) {
                return request;
            }
            if (this.limit <= this.count) {
                throw new EOFException();
            }
            return Math.min(request, (int)(this.limit - this.count));
        }

        private long checkLimit(long request) throws IOException {
            if (this.limit < 0L) {
                return request;
            }
            if (this.limit <= this.count) {
                throw new EOFException();
            }
            return Math.min(request, this.limit - this.count);
        }
    }
}

