/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOReader;
import hep.io.stdhep.StdhepBeginRun;
import hep.io.stdhep.StdhepConstants;
import hep.io.stdhep.StdhepEndRun;
import hep.io.stdhep.StdhepEvent;
import hep.io.stdhep.StdhepExtendedEvent;
import hep.io.stdhep.StdhepRecord;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StdhepReader
extends MCFIOReader
implements StdhepConstants {
    public StdhepReader(String file) throws IOException {
        super(file);
    }

    public StdhepReader(InputStream stream) throws IOException {
        super(stream);
    }

    public StdhepRecord nextRecord() throws IOException {
        MCFIOEvent event;
        int nBlocks;
        while ((nBlocks = (event = super.nextEvent()).getNBlocks()) == 0) {
        }
        if (nBlocks != 1) {
            throw new IOException("Invalid stdhep record found (NBlocks=" + nBlocks + ")");
        }
        return (StdhepRecord)event.getBlock(0);
    }

    public StdhepRecord goToRecord(int runNumber, int eventNumber) throws IOException {
        boolean hasRewound = false;
        while (true) {
            try {
                int nBlocks;
                MCFIOEvent event;
                while ((event = super.nextEvent()).getRunNumber() != runNumber || event.getEventNumber() != eventNumber || (nBlocks = event.getNBlocks()) == 0) {
                }
                if (nBlocks != 1) {
                    throw new IOException("Invalid stdhep record found (NBlocks=" + nBlocks + ")");
                }
                return (StdhepRecord)event.getBlock(0);
            }
            catch (EOFException x) {
                if (!hasRewound) {
                    this.rewind();
                    hasRewound = true;
                    continue;
                }
                throw x;
            }
            break;
        }
    }

    @Override
    public void skip(int nEvents) throws IOException {
        super.skip(nEvents);
    }

    @Override
    protected MCFIOBlock createUserBlock(int id) throws IOException {
        switch (id) {
            case 101: {
                return new StdhepEvent();
            }
            case 106: {
                return new StdhepBeginRun();
            }
            case 107: {
                return new StdhepEndRun();
            }
            case 201: {
                return new StdhepExtendedEvent();
            }
        }
        return super.createUserBlock(id);
    }
}

