/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.adapter.test;

import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepWriter;
import hep.graphics.heprep1.HepRep;
import hep.graphics.heprep1.adapter.HepRepAdapterFactory;
import hep.graphics.heprep1.adapter.NumericalComparator;
import hep.graphics.heprep1.xml.XMLHepRepReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HepRep1toHepRep2Converter {
    public HepRep1toHepRep2Converter(String source, String dest) throws Exception {
        XMLHepRepReader in = new XMLHepRepReader(new FileInputStream(source));
        HepRep heprep1 = in.next();
        in.close();
        HepRepAdapterFactory factory = HepRepAdapterFactory.getFactory();
        hep.graphics.heprep.HepRep heprep = factory.createHepRep();
        ArrayList layers = new ArrayList();
        hep.graphics.heprep.HepRep event = factory.createHepRep(heprep1);
        heprep.addTypeTree(event.getTypeTree("Types", "1.0"));
        HepRepInstanceTree instanceTree = event.getInstanceTreeTop("Instances", "1.0");
        heprep.addInstanceTree(instanceTree);
        layers.addAll(event.getLayerOrder());
        Collections.sort(layers, new NumericalComparator());
        Iterator i = layers.iterator();
        while (i.hasNext()) {
            heprep.addLayer((String)i.next());
        }
        HepRepWriter writer = factory.createHepRepWriter(new FileOutputStream(dest), false, false);
        writer.write(heprep, "Event");
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: HepRep1toHepRep2Converter sourcefile destfile");
            System.exit(1);
        }
        try {
            new HepRep1toHepRep2Converter(args[0], args[1]);
        }
        catch (SAXParseException e) {
            System.out.println(e + " in " + args[0] + " at line: " + e.getLineNumber() + ", col: " + e.getColumnNumber());
        }
        catch (SAXException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

