/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.wbxml;

import hep.graphics.heprep.wbxml.BHepRepParser;
import hep.graphics.heprep.wbxml.WbxmlParser;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.xmlpull.v1.XmlPullParserException;

public class BHepRepDump
extends BHepRepParser {
    private long offset;
    private int bytes;

    @Override
    protected int readVersion() throws IOException {
        int version = super.readByte();
        this.print("VERSION " + version);
        return version;
    }

    @Override
    protected int readPublicIdentifierId() throws IOException {
        int id = super.readPublicIdentifierId();
        if (id == 0) {
            this.print("PUBIDREF");
        } else {
            this.print("PUBID " + id);
        }
        return id;
    }

    @Override
    protected int readCharSet() throws IOException {
        int charSet = super.readCharSet();
        this.print("CHARSET " + charSet);
        return charSet;
    }

    @Override
    protected String readStringTable() throws IOException {
        String table = super.readStringTable();
        this.print("STRTABLE (" + table.length() + ") " + table);
        return table;
    }

    @Override
    protected void selectPage(int nr, boolean tags) throws XmlPullParserException {
        super.selectPage(nr, tags);
        this.print("SWITCHPAGE " + nr);
    }

    @Override
    protected void parseElement(int id) throws IOException, XmlPullParserException {
        int tagId = id & 0x3F;
        String name = "TAG";
        if ((id & 0xC0) != 0) {
            name = name + "_";
        }
        if ((id & 0x80) != 0) {
            name = name + "A";
        }
        if ((id & 0x40) != 0) {
            name = name + "C";
        }
        name = name + " (" + tagId + ") ";
        name = name + this.resolveId("TAG", this.tagTable, tagId);
        this.print(name);
        super.parseElement(id);
    }

    @Override
    protected String resolveId(String type, String[] tab, int id) throws IOException {
        String s = super.resolveId(type, tab, id);
        if (type.equals("TAG")) {
            return s;
        }
        this.print(type + " " + s);
        return s;
    }

    @Override
    protected void endAttributes() throws IOException, XmlPullParserException {
        this.print("ATTREND (01)");
    }

    @Override
    protected void endTag(WbxmlParser.Tag tag) throws IOException, XmlPullParserException {
        this.print("TAGEND (01) " + tag.name);
    }

    @Override
    protected void processInstruction() throws IOException, XmlPullParserException {
        this.print("PI");
        super.processInstruction();
    }

    @Override
    protected Object parseExtension(int id, int tagId, int attId) throws IOException, XmlPullParserException {
        Object obj = super.parseExtension(id, tagId, attId);
        this.print(BHepRepDump.getWapExtension(id) + " " + (obj != null ? obj.toString() : ""));
        return obj;
    }

    @Override
    protected Object parseOpaque(int len, int tagId, int attId) throws IOException, XmlPullParserException {
        this.print("OPAQUE len=" + len);
        return super.parseOpaque(len, tagId, attId);
    }

    @Override
    protected String readStrI() throws IOException {
        String s = super.readStrI();
        return s;
    }

    @Override
    protected float readFloat() throws IOException {
        float f = super.readFloat();
        this.print("float " + f);
        return f;
    }

    @Override
    protected double readDouble() throws IOException {
        double d = super.readDouble();
        this.print("double " + d);
        return d;
    }

    @Override
    protected int readInt32() throws IOException {
        int i = super.readInt32();
        this.print("int32 " + i);
        return i;
    }

    @Override
    protected long readInt64() throws IOException {
        long l = super.readInt64();
        this.print("int64 " + l);
        return l;
    }

    private String hex(long i, int w) {
        String hex = "00000000" + Long.toHexString(i);
        return hex.substring(hex.length() - w, hex.length());
    }

    private void print(String s) {
        if (s != null) {
            while (this.bytes < 8) {
                System.out.print("   ");
                ++this.bytes;
            }
            System.out.print(" ; ");
            System.out.print(s);
        }
        System.out.println();
        this.bytes = 0;
        System.out.print("0x");
        System.out.print(this.hex(this.offset, 8));
        System.out.print(":");
    }

    private void dump(final InputStream in) throws IOException, XmlPullParserException {
        InputStream dumpIn = new InputStream(){

            @Override
            public int read() throws IOException {
                int b = in.read();
                if (b < 0) {
                    return b;
                }
                BHepRepDump.this.offset++;
                if (BHepRepDump.this.bytes >= 8) {
                    BHepRepDump.this.print(null);
                }
                System.out.print(" ");
                System.out.print(BHepRepDump.this.hex(b, 2));
                BHepRepDump.this.bytes++;
                return b;
            }
        };
        this.offset = 0L;
        this.bytes = 0;
        this.print(null);
        this.setInput(dumpIn, null);
        int eventType = this.getEventType();
        while (eventType != 1) {
            while (eventType != 1) {
                try {
                    eventType = this.next();
                }
                catch (Exception e) {
                    System.out.println(this.getPositionDescription());
                }
            }
            this.print("**************");
            this.print("End of BHepRep");
            this.print("**************");
            eventType = this.next();
        }
    }

    public static void main(String[] args) throws IOException, XmlPullParserException, FileNotFoundException {
        if (args.length != 1) {
            System.err.println("Usage: BHepRepDump binaryheprepfile");
            System.exit(1);
        }
        BHepRepDump p = new BHepRepDump();
        InputStream in = new FileInputStream(args[0]);
        if (args[0].endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        p.dump(in);
    }
}

