/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.util;

import hep.graphics.heprep.HepRepAttDef;
import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepAttribute;
import hep.graphics.heprep.HepRepConverter;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepIterator;
import hep.graphics.heprep.HepRepProvider;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.ref.DefaultHepRepIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openide.util.Lookup;

public class HepRepUtil {
    private static char[] hexChars = new char[16];
    private static char[] specialChars = new char[16];

    private HepRepUtil() {
    }

    public static boolean debug() {
        return false;
    }

    public static double decodeNumber(String s) {
        double d = 0.0;
        try {
            d = s.startsWith("0ds") ? Double.longBitsToDouble(HepRepUtil.decodeSpecial(s.substring(3))) : (s.startsWith("0d0x") ? Double.longBitsToDouble(HepRepUtil.decodeHex(s.substring(4))) : (s.startsWith("0d#") ? Double.longBitsToDouble(HepRepUtil.decodeHex(s.substring(3))) : (s.startsWith("0d") ? Double.longBitsToDouble(HepRepUtil.decodeHex(s.substring(2))) : (s.startsWith("0x") ? Long.decode(s).doubleValue() : (s.indexOf(".") < 0 && s.indexOf("E") < 0 && s.indexOf("e") < 0 ? Long.decode(s).doubleValue() : Double.valueOf(s).doubleValue())))));
        }
        catch (NumberFormatException nfe) {
            System.err.println("decodeNumber: " + s);
            nfe.printStackTrace();
            throw nfe;
        }
        return d;
    }

    public static long decodeHex(String s) throws NumberFormatException {
        long result = 0L;
        int len = Math.min(hexChars.length, s.length());
        s.getChars(0, len, hexChars, 0);
        for (int i = 0; i < len; ++i) {
            result <<= 4;
            char c = hexChars[i];
            if ('0' <= c && c <= '9') {
                result += (long)(c - 48);
                continue;
            }
            if ('A' <= c && c <= 'F') {
                result += (long)(c - 65 + 10);
                continue;
            }
            if ('a' <= c && c <= 'f') {
                result += (long)(c - 97 + 10);
                continue;
            }
            throw new NumberFormatException("Not a hex number: " + s);
        }
        return result;
    }

    public static long decodeSpecial(String s) throws NumberFormatException {
        long result = 0L;
        int len = Math.min(specialChars.length, s.length());
        s.getChars(0, len, specialChars, 0);
        for (int i = 0; i < len; ++i) {
            result <<= 6;
            char c = specialChars[i];
            if ('0' <= c && c <= '9') {
                result += (long)(c - 48);
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                result += (long)(c - 65 + 10);
                continue;
            }
            if ('a' <= c && c <= '|') {
                result += (long)(c - 97 + 10 + 26);
                continue;
            }
            throw new NumberFormatException("Not a special number: " + s);
        }
        return result;
    }

    public static String encodeSpecial(long d) {
        for (int i = 10; i >= 0; --i) {
            int c = (int)(d & 0x3FL);
            if (c < 10) {
                HepRepUtil.specialChars[i] = (char)(48 + c);
            } else if (c < 36) {
                HepRepUtil.specialChars[i] = (char)(65 + c - 10);
            } else if (c < 64) {
                HepRepUtil.specialChars[i] = (char)(97 + c - 10 - 26);
            } else {
                System.err.println("encodeSpecial: this looks bad.");
            }
            d >>>= 6;
        }
        return new String(specialChars, 0, 11);
    }

    public static void main(String[] args) {
        System.out.println("" + Long.toHexString(HepRepUtil.decodeSpecial("0123456789ABCDEF")));
        System.out.println("" + Long.toHexString(HepRepUtil.decodeSpecial("GHIJKLMNOPQRSTUV")));
        System.out.println("" + Long.toHexString(HepRepUtil.decodeSpecial("WXYZabcdefghijkl")));
        System.out.println("" + HepRepUtil.encodeSpecial(6460310975675554735L));
        System.out.println("" + Long.toHexString(HepRepUtil.decodeSpecial("mnopqrstuvwxyz{|")));
        System.out.println("" + HepRepUtil.encodeSpecial(6753116437163007935L));
    }

    public static void copyAttributes(HepRepAttribute src, HepRepAttribute dst) throws CloneNotSupportedException {
        HepRepAttValue layerAtt = src.getAttValueFromNode("layer");
        if (layerAtt != null) {
            dst.addAttValue(layerAtt.copy());
        }
        for (HepRepAttValue value : src.getAttValuesFromNode()) {
            dst.addAttValue(value.copy());
        }
    }

    public static HepRepType getType(Collection types, String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        int slash = name.indexOf("/");
        String rest = "";
        if (slash >= 0) {
            rest = name.substring(slash + 1);
            name = name.substring(0, slash);
        }
        for (HepRepType type : types) {
            if (!type.getName().equals(name)) continue;
            if (rest.equals("")) {
                return type;
            }
            return HepRepUtil.getType(type.getTypeList(), rest);
        }
        return null;
    }

    public static HepRepIterator getInstances(List instanceTrees, List layers, Set types, boolean iterateFrames) {
        return new DefaultHepRepIterator(instanceTrees, layers, types, iterateFrames);
    }

    public static Iterator iterator(Iterator first, Iterator second) {
        final Iterator f = first != null ? first : Collections.EMPTY_LIST.iterator();
        final Iterator s = second != null ? second : Collections.EMPTY_LIST.iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return f.hasNext() || s.hasNext();
            }

            public Object next() {
                if (f.hasNext()) {
                    return f.next();
                }
                return s.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static HepRepProvider getHepRepProvider(Lookup registry, Object object) {
        Collection allConverters = registry.lookup(new Lookup.Template(HepRepProvider.class)).allInstances();
        for (HepRepProvider converter : allConverters) {
            if (!converter.canConvert(object)) continue;
            return converter;
        }
        return null;
    }

    public static HepRepConverter getHepRepConverter(Lookup registry, Class cls) {
        Collection allConverters = registry.lookup(new Lookup.Template(HepRepConverter.class)).allInstances();
        for (HepRepConverter converter : allConverters) {
            if (!converter.canHandle(cls)) continue;
            return converter;
        }
        return null;
    }

    public static String getUnit(HepRepAttDef attDef) {
        String extra = attDef.getExtra();
        if (extra == null) {
            return null;
        }
        int colon = extra.indexOf(":");
        return colon >= 0 ? extra.substring(0, colon) : extra;
    }

    public static Set getAllLayerNames(HepRepInstanceTree instanceTree, boolean checkVisible, boolean checkPickable) {
        HashSet<String> names = new HashSet<String>();
        ArrayList<HepRepInstanceTree> trees = new ArrayList<HepRepInstanceTree>();
        trees.add(instanceTree);
        HepRepIterator iterator = HepRepUtil.getInstances(trees, null, null, false);
        while (iterator.hasNext()) {
            HepRepInstance instance = iterator.nextInstance();
            if (checkPickable && !instance.getAttValue("ispickable").getBoolean() || checkVisible && !instance.getAttValue("visibility").getBoolean()) continue;
            names.add(instance.getAttValue("layer").getString());
        }
        return names;
    }
}

