/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.util;

import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HepRepTypes {
    private Map typeTrees = new HashMap();
    private Map flatTypeTrees = new HashMap();

    public void put(HepRepTreeID id, HepRepTypeTree tree) {
        this.typeTrees.put(this.getID(id), tree);
        this.flatTypeTrees.put(this.getID(id), new HashMap());
    }

    public void put(HepRepTypeTree tree, String name, HepRepType type) {
        Map types = (Map)this.flatTypeTrees.get(this.getID(tree));
        if (types != null) {
            if (types.get(name) == null) {
                types.put(name, type);
            } else {
                this.flatTypeTrees.put(this.getID(tree), null);
            }
        }
    }

    public HepRepType getType(HepRepTreeID treeID, String name, HepRepInstance parent) {
        HepRepType type = this.getTypeFromFlatNamespace(treeID, name);
        if (type != null) {
            return type;
        }
        type = this.getTypeFromHierarchicalNamespace(treeID, name);
        if (type != null) {
            return type;
        }
        return this.getTypeFromHierarchicalNamespace(treeID, parent.getType().getFullName() + "/" + name);
    }

    private HepRepType getTypeFromFlatNamespace(HepRepTreeID treeID, String name) {
        Map flatTypes = (Map)this.flatTypeTrees.get(this.getID(treeID));
        if (flatTypes == null) {
            return null;
        }
        return (HepRepType)flatTypes.get(name);
    }

    private HepRepType getTypeFromHierarchicalNamespace(HepRepTreeID treeID, String name) {
        int slash;
        HepRepType type = null;
        HepRepTypeTree tree = (HepRepTypeTree)this.typeTrees.get(this.getID(treeID));
        if (tree == null) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        List types = tree.getTypeList();
        do {
            String partName = (slash = name.indexOf("/")) < 0 ? name : name.substring(0, slash);
            String string = name = slash < 0 ? "" : name.substring(slash + 1);
            if (types == null) {
                return null;
            }
            Iterator typeIterator = types.iterator();
            boolean found = false;
            while (!found && typeIterator.hasNext()) {
                type = (HepRepType)typeIterator.next();
                if (!type.getName().equals(partName)) continue;
                types = type.getTypeList();
                found = true;
            }
            if (found) continue;
            return null;
        } while (slash >= 0);
        return type;
    }

    public String getID(HepRepTreeID id) {
        return id.getName() + ":" + id.getVersion();
    }
}

