/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.test;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.HepRepWriter;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import hep.graphics.heprep.xml.XMLHepRepFactory;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;

public class CreateTest {
    public static void main(String[] args) throws Exception {
        HepRepWriter writer;
        FileOutputStream out;
        System.out.println("Finding Factory...");
        HepRepFactory factory = DefaultHepRepFactory.create();
        System.out.println("Creating HepRep...");
        HepRep root = factory.createHepRep();
        System.out.println("Creating Layer...");
        String layer = "Detector";
        root.addLayer(layer);
        System.out.println("Creating HepRepTreeID...");
        HepRepTreeID treeID = factory.createHepRepTreeID("CylinderType", "1.0");
        System.out.println("Creating HepRepTypeTree...");
        HepRepTypeTree typeTree = factory.createHepRepTypeTree(treeID);
        root.addTypeTree(typeTree);
        System.out.println("Creating HepRepType...");
        HepRepType type = factory.createHepRepType(typeTree, "Cylinder");
        type.addAttValue("layer", layer);
        type.addAttValue("banner", "true");
        type.addAttValue("framed", "true");
        type.addAttValue("drawAs", "Cylinder");
        type.addAttValue("radius", "2", 1029);
        System.out.println("Creating HepRepInstanceTree...");
        HepRepInstanceTree instanceTree = factory.createHepRepInstanceTree("TestCylinder", "CPlusPlus Generated", typeTree);
        root.addInstanceTree(instanceTree);
        System.out.println("Creating HepRepInstance...");
        HepRepInstance instance1 = factory.createHepRepInstance(instanceTree, type);
        instance1.addAttValue("color", Color.CYAN);
        instance1.addAttValue("label", "x-axis", 4);
        factory.createHepRepPoint(instance1, 0.0, 0.0, 0.0);
        factory.createHepRepPoint(instance1, 4.0, 0.0, 0.0);
        HepRepInstance instance2 = factory.createHepRepInstance(instanceTree, type);
        instance2.addAttValue("color", Color.ORANGE, 0);
        instance2.addAttValue("label", "y-axis", 4);
        factory.createHepRepPoint(instance2, 0.0, 0.0, 0.0);
        factory.createHepRepPoint(instance2, 0.0, 4.0, 0.0);
        HepRepInstance instance3 = factory.createHepRepInstance(instanceTree, type);
        instance3.addAttValue("color", Color.GREEN, 0);
        instance3.addAttValue("label", "z-axis", 4);
        factory.createHepRepPoint(instance3, 0.0, 0.0, 0.0);
        factory.createHepRepPoint(instance3, 0.0, 0.0, 4.0);
        HepRepInstance instance4 = factory.createHepRepInstance(instanceTree, type);
        HepRepPoint p1 = factory.createHepRepPoint(instance4, 10.0, 10.0, 10.0);
        p1.addAttValue("Phi", "0.2", 0);
        HepRepPoint p2 = factory.createHepRepPoint(instance4, 12.3, 12.3, 12.3);
        p2.addAttValue("Phi", "0.3", 0);
        System.out.println("Saving HepRep as ser ...");
        try {
            out = new FileOutputStream("HepRepTest.ser");
            writer = factory.createHepRepWriter(out, false, false);
            writer.write(root, null);
            writer.close();
        }
        catch (IOException ioe) {
            System.err.println("Could not write ser file " + ioe);
        }
        System.out.println("Saving HepRep as ser.gz ...");
        try {
            out = new FileOutputStream("HepRepTest.ser.gz");
            writer = factory.createHepRepWriter(out, false, true);
            writer.write(root, null);
            writer.close();
        }
        catch (IOException ioe) {
            System.err.println("Could not write ser.gz file " + ioe);
        }
        System.out.println("Saving HepRep as xml ...");
        try {
            out = new FileOutputStream("HepRepTest.xml");
            writer = new XMLHepRepFactory().createHepRepWriter(out, false, false);
            writer.write(root, null);
            writer.close();
        }
        catch (IOException ioe) {
            System.err.println("Could not write xml file " + ioe);
        }
        System.out.println("Saving HepRep as xml.gz ...");
        try {
            out = new FileOutputStream("HepRepTest.xml.gz");
            writer = new XMLHepRepFactory().createHepRepWriter(out, false, true);
            writer.write(root, null);
            writer.close();
        }
        catch (IOException ioe) {
            System.err.println("Could not write xml.gz file " + ioe);
        }
        System.out.println("Test finished ok.");
    }
}

