/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.ref.DefaultHepRepAttribute;
import hep.graphics.heprep.util.HepRepMath;
import hep.graphics.heprep.util.HepRepUtil;
import java.io.Serializable;

public class DefaultHepRepPoint
extends DefaultHepRepAttribute
implements HepRepPoint,
Serializable {
    protected double x;
    protected double y;
    protected double z;
    protected HepRepInstance instance;

    protected DefaultHepRepPoint(HepRepInstance instance, double x, double y, double z) {
        if (instance == null) {
            throw new RuntimeException("HepRepPoints cannot be created without a HepRepInstance.");
        }
        this.instance = instance;
        this.x = x;
        this.y = y;
        this.z = z;
        instance.addPoint(this);
    }

    @Override
    public HepRepInstance getInstance() {
        return this.instance;
    }

    public String toString() {
        return this.getClass() + ": (" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    @Override
    public HepRepAttValue getAttValue(String lowerCaseName) {
        HepRepAttValue value = this.getAttValueFromNode(lowerCaseName);
        return value != null ? value : this.instance.getAttValue(lowerCaseName);
    }

    @Override
    public HepRepPoint copy(HepRepInstance parent) throws CloneNotSupportedException {
        DefaultHepRepPoint copy = new DefaultHepRepPoint(parent, this.getX(), this.getY(), this.getZ());
        HepRepUtil.copyAttributes(this, copy);
        return copy;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double[] getXYZ(double[] xyz) {
        if (xyz == null) {
            xyz = new double[]{this.x, this.y, this.z};
        }
        return xyz;
    }

    @Override
    public double getRho() {
        return HepRepMath.getRho(this.x, this.y);
    }

    @Override
    public double getPhi() {
        return HepRepMath.getPhi(this.x, this.y);
    }

    @Override
    public double getTheta() {
        return HepRepMath.getTheta(this.x, this.y, this.z);
    }

    @Override
    public double getR() {
        return HepRepMath.getR(this.x, this.y, this.z);
    }

    @Override
    public double getEta() {
        return HepRepMath.getEta(this.x, this.y, this.z);
    }

    @Override
    public double getX(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getX(this.x, xVertex);
    }

    @Override
    public double getY(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getY(this.y, yVertex);
    }

    @Override
    public double getZ(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getZ(this.z, zVertex);
    }

    @Override
    public double getRho(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getRho(this.x, this.y, xVertex, yVertex);
    }

    @Override
    public double getPhi(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getPhi(this.x, this.y, xVertex, yVertex);
    }

    @Override
    public double getTheta(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getTheta(this.x, this.y, this.z, xVertex, yVertex, zVertex);
    }

    @Override
    public double getR(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getR(this.x, this.y, this.z, xVertex, yVertex, zVertex);
    }

    @Override
    public double getEta(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getEta(this.x, this.y, this.z, xVertex, yVertex, zVertex);
    }
}

