/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepAttribute;
import hep.graphics.heprep.ref.DefaultHepRepPoint;
import hep.graphics.heprep.util.HepRepUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DefaultHepRepInstance
extends DefaultHepRepAttribute
implements HepRepInstance,
Serializable {
    private HepRepType type = null;
    private HepRepInstance parent;
    private List pointList;
    private double[][] points;
    private List instanceList;
    private transient Object userObject;
    private transient boolean valid;
    private transient String layer;
    private transient boolean hasFrame;

    protected DefaultHepRepInstance(HepRepInstance parent, HepRepType type) {
        if (type == null) {
            throw new RuntimeException("HepRepInstance cannot be created without a HepRepType.");
        }
        this.type = type;
        this.parent = parent;
        this.valid = false;
        this.layer = null;
        this.hasFrame = false;
        if (parent != null) {
            parent.addInstance(this);
        }
    }

    protected DefaultHepRepInstance(HepRepInstanceTree parent, HepRepType type) {
        this((HepRepInstance)null, type);
        this.valid = false;
        this.layer = null;
        this.hasFrame = false;
        parent.addInstance(this);
    }

    @Override
    public HepRepInstance getSuperInstance() {
        return this.parent;
    }

    @Override
    public void overlay(HepRepInstance instance) {
        if (this.getInstances().size() != instance.getInstances().size()) {
            throw new RuntimeException("HepRepInstance cannot overlay; not a compatible structure in terms of sub-instances.");
        }
        if (this.getPoints().size() > 0 && this.getPoints().size() != instance.getPoints().size()) {
            throw new RuntimeException("HepRepInstance cannot overlay; not a compatible structure in terms of points.");
        }
        for (HepRepPoint point : instance.getPoints()) {
            this.addPoint(point);
        }
        for (HepRepAttValue value : instance.getAttValuesFromNode()) {
            this.addAttValue(value);
        }
        this.optimize();
        this.validate();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstance parent) throws CloneNotSupportedException {
        return this.copy(typeTree, parent, null);
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstanceTree parent) throws CloneNotSupportedException {
        return this.copy(typeTree, parent, null);
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstance parent, HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRepType type = typeTree.getType(this.getType().getFullName());
        DefaultHepRepInstance instanceCopy = new DefaultHepRepInstance(parent, type);
        return this.copy(typeTree, instanceCopy, filter);
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstanceTree parent, HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRepType type = typeTree.getType(this.getType().getFullName());
        DefaultHepRepInstance instanceCopy = new DefaultHepRepInstance(parent, type);
        return this.copy(typeTree, instanceCopy, filter);
    }

    private HepRepInstance copy(HepRepTypeTree typeTree, DefaultHepRepInstance instanceCopy, HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRepUtil.copyAttributes(this, instanceCopy);
        for (HepRepPoint point : this.getPoints()) {
            point.copy(instanceCopy);
        }
        for (HepRepInstance instance : this.getInstances()) {
            if (filter != null && !filter.select(instance)) continue;
            instance.copy(typeTree, instanceCopy, filter);
        }
        instanceCopy.optimize();
        instanceCopy.validate();
        return instanceCopy;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public HepRepType getType() {
        return this.type;
    }

    @Override
    public void addPoint(HepRepPoint point) throws UnsupportedOperationException {
        if (this.pointList == null) {
            this.pointList = new ArrayList();
        }
        this.pointList.add(point);
    }

    @Override
    public List getPoints() {
        if (this.pointList == null && this.points == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.pointList != null) {
            return this.pointList;
        }
        ArrayList<DefaultHepRepPoint> list = new ArrayList<DefaultHepRepPoint>(this.points.length);
        for (int i = 0; i < this.points.length; ++i) {
            list.add(new DefaultHepRepPoint(this, this.points[0][i], this.points[1][i], this.points[2][i]));
        }
        return list;
    }

    @Override
    public int getPoints(double[][] xyz) {
        if (this.pointList == null && this.points == null) {
            return 0;
        }
        if (this.points == null) {
            this.optimize();
        }
        if (this.points == null) {
            return -1;
        }
        int xPoints = xyz[0].length;
        int nPoints = this.points[0].length;
        int inc = xPoints < nPoints ? nPoints / xPoints : 0;
        ++inc;
        int i = 0;
        for (int j = 0; j < nPoints; j += inc) {
            xyz[0][i] = this.points[0][j];
            xyz[1][i] = this.points[1][j];
            xyz[2][i] = this.points[2][j];
            ++i;
        }
        return inc > 1 ? -nPoints : nPoints;
    }

    public void optimize() {
        if (this.points != null || this.pointList == null) {
            return;
        }
        this.points = new double[3][this.pointList.size()];
        int j = 0;
        for (HepRepPoint p : this.pointList) {
            if (!p.getAttValuesFromNode().isEmpty()) {
                this.points = null;
                return;
            }
            this.points[0][j] = p.getX();
            this.points[1][j] = p.getY();
            this.points[2][j] = p.getZ();
            ++j;
        }
    }

    @Override
    public void addInstance(HepRepInstance instance) throws UnsupportedOperationException {
        if (this.instanceList == null) {
            this.instanceList = new ArrayList();
        }
        this.instanceList.add(instance);
    }

    @Override
    public void removeInstance(HepRepInstance instance) throws UnsupportedOperationException {
        if (this.instanceList != null) {
            this.instanceList.remove(instance);
        }
    }

    @Override
    public List getInstances() {
        if (this.instanceList == null) {
            return Collections.EMPTY_LIST;
        }
        return this.instanceList;
    }

    @Override
    public HepRepAttValue getAttValue(String name) {
        String lowerCaseName = name.toLowerCase();
        HepRepAttValue value = this.getAttValueFromNode(lowerCaseName);
        return value != null ? value : this.type.getAttValue(lowerCaseName);
    }

    public String toString() {
        return "DefaultHepRepInstance: " + this.getType();
    }

    int getNoOfInstances() {
        int n = 0;
        for (DefaultHepRepInstance instance : this.getInstances()) {
            ++n;
            n += instance.getNoOfInstances();
        }
        return n;
    }

    int getNoOfPoints() {
        int p = this.getPoints().size();
        for (DefaultHepRepInstance instance : this.getInstances()) {
            p += instance.getNoOfPoints();
        }
        return p;
    }

    int getNoOfAttValues() {
        int v = this.getAttValuesFromNode().size();
        for (DefaultHepRepInstance instance : this.getInstances()) {
            v += instance.getNoOfAttValues();
        }
        return v;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void validate() {
        if (this.valid) {
            return;
        }
        this.layer = this.getAttValue("layer").getString();
        this.hasFrame = this.getAttValue("hasframe").getBoolean();
        this.valid = true;
    }

    @Override
    public String getLayer() {
        this.validate();
        return this.layer;
    }

    @Override
    public boolean hasFrame() {
        this.validate();
        return this.hasFrame;
    }
}

