/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepDefaults;
import hep.graphics.heprep.HepRepTypeException;
import hep.graphics.heprep.util.HepRepColor;
import hep.graphics.heprep.util.HepRepUtil;
import hep.graphics.heprep.xml.XMLHepRepReader;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.freehep.swing.ColorConverter;
import org.freehep.util.ScientificFormat;

public class DefaultHepRepAttValue
implements HepRepAttValue,
Serializable {
    private static final ScientificFormat scientific = new ScientificFormat();
    private String name;
    private String lowerCaseName;
    private String lowerCaseString;
    private Object objectValue;
    private long longValue;
    private double doubleValue;
    private boolean booleanValue;
    private int type;
    private int showLabel;
    private static String[] labelStrings = new String[]{"NAME", "DESC", "VALUE", "EXTRA"};
    private static Map labelTable = new HashMap(5);
    private static final Map stringToType;
    private static final Map types;

    private DefaultHepRepAttValue() {
    }

    void replace(DefaultHepRepAttValue attValue) {
        this.name = attValue.name;
        this.lowerCaseName = attValue.lowerCaseName;
        this.lowerCaseString = attValue.lowerCaseString;
        this.objectValue = attValue.objectValue;
        this.longValue = attValue.longValue;
        this.doubleValue = attValue.doubleValue;
        this.booleanValue = attValue.booleanValue;
        this.type = attValue.type;
        this.showLabel = attValue.showLabel;
    }

    public DefaultHepRepAttValue(String name, String value, int showLabel) {
        this.init(name, 1, showLabel);
        this.objectValue = value == null ? null : value.intern();
        this.lowerCaseString = value == null ? null : value.toLowerCase().intern();
    }

    public DefaultHepRepAttValue(String name, Color value, int showLabel) {
        this.init(name, 2, showLabel);
        this.objectValue = value;
    }

    public DefaultHepRepAttValue(String name, long value, int showLabel) {
        this.init(name, 10, showLabel);
        this.longValue = value;
    }

    public DefaultHepRepAttValue(String name, int value, int showLabel) {
        this.init(name, 11, showLabel);
        this.longValue = value;
    }

    public DefaultHepRepAttValue(String name, double value, int showLabel) {
        this.init(name, 20, showLabel);
        this.doubleValue = value;
    }

    public DefaultHepRepAttValue(String name, boolean value, int showLabel) {
        this.init(name, 30, showLabel);
        this.booleanValue = value;
    }

    public DefaultHepRepAttValue(String name, String value, String type, int showLabel) {
        int t = DefaultHepRepAttValue.toType(type);
        this.init(name, t, showLabel);
        switch (t) {
            case 1: {
                this.objectValue = value.intern();
                this.lowerCaseString = value.toLowerCase().intern();
                break;
            }
            case 2: {
                this.objectValue = HepRepColor.get(value);
                break;
            }
            case 10: {
                this.longValue = Long.decode(value);
                break;
            }
            case 11: {
                this.longValue = Integer.decode(value).intValue();
                break;
            }
            case 20: {
                this.doubleValue = HepRepUtil.decodeNumber(value);
                break;
            }
            case 30: {
                this.booleanValue = Boolean.valueOf(value);
                break;
            }
            default: {
                System.err.println("Unknown type in DefaultHepRepAttValue: '" + type + "'");
                this.objectValue = value;
            }
        }
    }

    private void init(String name, int type, int showLabel) {
        this.name = name.intern();
        this.lowerCaseName = name.toLowerCase().intern();
        this.type = type;
        this.showLabel = showLabel;
    }

    @Override
    public HepRepAttValue copy() throws CloneNotSupportedException {
        DefaultHepRepAttValue copy = new DefaultHepRepAttValue();
        copy.init(this.name, this.type, this.showLabel);
        copy.lowerCaseString = this.lowerCaseString;
        copy.objectValue = this.objectValue;
        copy.longValue = this.longValue;
        copy.doubleValue = this.doubleValue;
        copy.booleanValue = this.booleanValue;
        return copy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getTypeName() {
        return DefaultHepRepAttValue.toString(this.type);
    }

    public static int toShowLabel(String labelString) {
        int showLabel = 0;
        if (labelString != null) {
            StringTokenizer st = new StringTokenizer(labelString, ", ");
            while (st.hasMoreTokens()) {
                String label = st.nextToken();
                Integer number = (Integer)labelTable.get(label);
                if (number != null) {
                    showLabel += number.intValue();
                    continue;
                }
                showLabel += Integer.decode(label).intValue();
            }
        }
        return showLabel;
    }

    public static String toShowLabel(int showLabel) {
        String label = null;
        if (showLabel == 0) {
            label = "NONE";
        } else {
            for (int i = 0; i < 16; ++i) {
                if ((showLabel >> i & 1) != 1) continue;
                label = label == null ? "" : label + ", ";
                label = i < labelStrings.length ? label + labelStrings[i] : label + "0x" + Integer.toHexString(1 << i);
            }
        }
        return label;
    }

    public static String toString(int type) {
        switch (type) {
            case 1: {
                return "String";
            }
            case 2: {
                return "Color";
            }
            case 10: {
                return "long";
            }
            case 11: {
                return "int";
            }
            case 20: {
                return "double";
            }
            case 30: {
                return "boolean";
            }
        }
        throw new RuntimeException("Unknown type stored in HepRepAttDef: '" + type + "'");
    }

    public static int toType(String type) {
        Integer code = type != null ? (Integer)stringToType.get(type) : null;
        return code == null ? -1 : code;
    }

    public static void addGuessedType(String name, String type) {
        types.put(name.toLowerCase(), type);
    }

    public static String guessType(String name, String value, String type) {
        if (type != null) {
            return type;
        }
        type = DefaultHepRepAttValue.guessTypeFromName(name);
        if (type == null) {
            type = DefaultHepRepAttValue.guessTypeFromValue(value);
            if (!type.equals("String")) {
                System.out.println("Guessed type for '" + name + "' to be '" + type + "'.");
            }
            types.put(name.toLowerCase(), type);
        }
        return type;
    }

    public static String guessTypeFromName(String name) {
        return (String)types.get(name.toLowerCase());
    }

    public static String guessTypeFromValue(String value) {
        if (value == null) {
            return "String";
        }
        try {
            Double.valueOf(value);
            return "double";
        }
        catch (NumberFormatException e) {
            if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
                return "boolean";
            }
            try {
                ColorConverter cc = new ColorConverter();
                cc.stringToColor(value);
                return "Color";
            }
            catch (ColorConverter.ColorConversionException colorConversionException) {
                return "String";
            }
        }
    }

    @Override
    public int showLabel() {
        return this.showLabel;
    }

    @Override
    public String getString() throws HepRepTypeException {
        try {
            return (String)this.objectValue;
        }
        catch (ClassCastException cce) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "' with value '" + this.getAsString() + "' of type '" + this.getTypeName() + "' cannot be converted to type 'String'");
        }
    }

    @Override
    public String getLowerCaseString() throws HepRepTypeException {
        try {
            return this.lowerCaseString;
        }
        catch (ClassCastException cce) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "' with value '" + this.getAsString() + "' of type '" + this.getTypeName() + "' cannot be converted to type 'String'");
        }
    }

    @Override
    public Color getColor() throws HepRepTypeException {
        try {
            return (Color)this.objectValue;
        }
        catch (ClassCastException cce) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "' with value '" + this.getAsString() + "' of type '" + this.getTypeName() + "' cannot be converted to type 'Color'");
        }
    }

    @Override
    public long getLong() throws HepRepTypeException {
        if (this.type != 10 && this.type != 11) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "' with value '" + this.getAsString() + "' of type '" + this.getTypeName() + "' cannot be converted to type 'long'");
        }
        return this.longValue;
    }

    @Override
    public int getInteger() throws HepRepTypeException {
        if (this.type != 11) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "' with value '" + this.getAsString() + "' of type '" + this.getTypeName() + "' cannot be converted to type 'int'");
        }
        return (int)this.longValue;
    }

    @Override
    public double getDouble() throws HepRepTypeException {
        if (this.type != 20 && this.type != 10 && this.type != 11) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "' with value '" + this.getAsString() + "' of type '" + this.getTypeName() + "' cannot be converted to type 'double'");
        }
        return this.type == 20 ? this.doubleValue : (double)this.longValue;
    }

    @Override
    public boolean getBoolean() throws HepRepTypeException {
        if (this.type != 30 && this.type != 10 && this.type != 11) {
            throw new HepRepTypeException("Attribute Value for '" + this.getName() + "'and value+'" + this.objectValue + "' of type'" + this.getTypeName() + "' cannot be converted to type 'boolean'");
        }
        return this.type == 30 ? this.booleanValue : this.longValue != 0L;
    }

    @Override
    public String getAsString() {
        return DefaultHepRepAttValue.getAsString(this);
    }

    public static String getAsString(HepRepAttValue attValue) {
        switch (attValue.getType()) {
            case 1: {
                return attValue.getString();
            }
            case 2: {
                return DefaultHepRepAttValue.getAsString(attValue.getColor());
            }
            case 10: {
                return DefaultHepRepAttValue.getAsString(attValue.getLong());
            }
            case 11: {
                return DefaultHepRepAttValue.getAsString(attValue.getInteger());
            }
            case 20: {
                return DefaultHepRepAttValue.getAsString(attValue.getDouble());
            }
            case 30: {
                return DefaultHepRepAttValue.getAsString(attValue.getBoolean());
            }
        }
        return "Unknown typecode: " + attValue.getType();
    }

    public static String getAsString(Color value) {
        return HepRepColor.get(value);
    }

    public static String getAsString(long value) {
        return Long.toString(value);
    }

    public static String getAsString(int value) {
        return Integer.toString(value);
    }

    public static String getAsString(double value) {
        return scientific.format(value);
    }

    public static String getAsString(boolean value) {
        return value ? "true" : "false";
    }

    public String toString() {
        return this.getClass() + "[" + "name(lcase)=" + this.getLowerCaseName() + ", " + "value=" + this.getAsString() + ", " + "showLabel=" + DefaultHepRepAttValue.toShowLabel(this.showLabel()) + "]";
    }

    static {
        labelTable.put("NONE", new Integer(0));
        labelTable.put("NAME", new Integer(1));
        labelTable.put("DESC", new Integer(2));
        labelTable.put("VALUE", new Integer(4));
        labelTable.put("EXTRA", new Integer(8));
        stringToType = new HashMap(6);
        stringToType.put("String", new Integer(1));
        stringToType.put("Color", new Integer(2));
        stringToType.put("long", new Integer(10));
        stringToType.put("int", new Integer(11));
        stringToType.put("double", new Integer(20));
        stringToType.put("boolean", new Integer(30));
        try {
            XMLHepRepReader.readDefaults();
        }
        catch (IOException ioe) {
            System.err.println("Problem reading HepRep Defaults " + ioe);
        }
        Set attValues = HepRepDefaults.getAttValues();
        types = new HashMap(attValues.size());
        for (HepRepAttValue attValue : attValues) {
            types.put(attValue.getLowerCaseName(), attValue.getTypeName());
        }
    }
}

