/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonData;
import hep.aida.util.comparison.AbstractComparisonAlgorithm;

public class KuiperComparisonAlgorithm
extends AbstractComparisonAlgorithm {
    private static final double ACCURACY = 0.001;
    private static final double CONVERGENCE = 1.0E-8;
    private static final String[] names = new String[]{"Kuiper"};
    private static final int dType = 1;
    private static final int eType = 1;

    public KuiperComparisonAlgorithm() {
        super(1, 1);
    }

    @Override
    public String[] algorithmNames() {
        return names;
    }

    @Override
    public double quality(IComparisonData d1, IComparisonData d2) {
        if (d1.type() != 1 || d2.type() != 1) {
            throw new IllegalArgumentException("The " + this.algorithmNames()[0] + " comparison can only be applyed to unbinned data.");
        }
        double[] cumulatived1 = this.getCumulativeArray(d1);
        double[] cumulatived2 = this.getCumulativeArray(d2);
        double dPlus = 0.0;
        double dMinus = 0.0;
        double data1 = 0.0;
        double data2 = 0.0;
        double cumulative1 = 0.0;
        double cumulative2 = 0.0;
        int j1 = 0;
        int j2 = 0;
        int nPoints1 = d1.nPoints();
        int nPoints2 = d2.nPoints();
        boolean flag1 = true;
        boolean flag2 = true;
        do {
            double delta;
            boolean advance1 = false;
            boolean advance2 = false;
            data1 = d1.value(j1);
            if (data1 <= (data2 = d2.value(j2))) {
                cumulative1 = cumulatived1[j1];
                advance1 = true;
            }
            if (data2 <= data1) {
                cumulative2 = cumulatived2[j2];
                advance2 = true;
            }
            if ((delta = cumulative2 - cumulative1) > dPlus) {
                dPlus = delta;
            }
            if (-1.0 * delta > dMinus) {
                dMinus = -1.0 * delta;
            }
            if (j1 == nPoints1 - 1) {
                flag1 = false;
            }
            if (j2 == nPoints2 - 1) {
                flag2 = false;
            }
            if (advance1) {
                if (flag1) {
                    ++j1;
                }
            } else if (!flag2 && flag1) {
                ++j1;
            }
            if (advance2) {
                if (!flag2) continue;
                ++j2;
                continue;
            }
            if (flag1 || !flag2) continue;
            ++j2;
        } while (flag1 || flag2);
        double distance = dPlus + dMinus;
        double entries1 = this.entries(d1);
        double entries2 = this.entries(d2);
        double eventProduct = entries1 * entries2;
        double eventSum = entries1 + entries2;
        double rootEvt = Math.sqrt(eventProduct / eventSum);
        double arg = (rootEvt + 0.155 + 0.24 / rootEvt) * distance;
        double arg2 = -2.0 * arg * arg;
        double factor = 2.0;
        double factor2 = 0.0;
        double product = 0.0;
        double term = 0.0;
        double soFar = 0.0;
        double sum = 0.0;
        double argument = 0.0;
        for (int i = 1; i < 100; ++i) {
            argument = arg2 * (double)i * (double)i;
            term = factor * Math.exp(argument);
            factor2 = -2.0 * arg2 * (double)i * (double)i - 1.0;
            product = factor2 * term;
            sum += product;
            if (Math.abs(term) <= soFar * 0.001 || Math.abs(term) <= sum * 1.0E-8) {
                return sum;
            }
            soFar = Math.abs(term);
        }
        return 1.0;
    }
}

