/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tree;

import hep.aida.IManagedObject;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.tree.Folder;
import hep.aida.ref.tree.Path;
import hep.aida.ref.tree.Tree;
import java.io.IOException;
import java.util.EventObject;

public class MountPoint
extends Folder
implements AIDAListener {
    private Folder mountPoint;
    private Tree tree;
    private Tree source;
    private boolean isUnmounted = false;
    int mountDepth;
    String[] prefix;

    MountPoint(Tree source, Path prefix, Tree tree, Folder mountPoint, Path mountPath) {
        super(prefix.getName());
        this.tree = tree;
        this.mountPoint = mountPoint;
        this.source = source;
        this.prefix = prefix.toArray();
        this.mountDepth = mountPath.size();
        tree.addListener(this);
    }

    @Override
    public void stateChanged(EventObject e) {
        if (!this.isUnmounted) {
            int i;
            TreeEvent te = (TreeEvent)e;
            String[] oldPath = te.getPath();
            int newDepth = oldPath.length - this.mountDepth + this.prefix.length;
            String[] newPath = new String[newDepth];
            for (i = 0; i < this.prefix.length; ++i) {
                newPath[i] = this.prefix[i];
            }
            while (i < newDepth) {
                newPath[i] = oldPath[i - this.prefix.length + this.mountDepth];
                ++i;
            }
            TreeEvent newEvent = new TreeEvent((Object)this.source, te.getID(), newPath, te.getType(), te.getFlags());
            this.source.fireStateChanged(newEvent);
        }
    }

    @Override
    IManagedObject getChild(int index) {
        return this.mountPoint.getChild(index);
    }

    @Override
    IManagedObject getChild(String name) {
        return this.mountPoint.getChild(name);
    }

    protected void unmount() {
        boolean wasUnmounted = this.isUnmounted;
        this.isUnmounted = true;
        if (!wasUnmounted) {
            Tree t = this.getTree();
            t.removeListener(this);
            try {
                if (t.decrementMountCount() == 0) {
                    t.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage());
            }
        }
    }

    @Override
    int getChildCount() {
        return this.mountPoint.getChildCount();
    }

    @Override
    int getIndexOfChild(IManagedObject child) {
        return this.mountPoint.getIndexOfChild(child);
    }

    @Override
    void add(IManagedObject object) {
        this.mountPoint.add(object);
    }

    @Override
    void remove(IManagedObject child) {
        this.mountPoint.remove(child);
    }

    @Override
    public String type() {
        return "mnt";
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    void setIsBeingWatched(boolean value) {
        super.setIsBeingWatched(value);
        this.mountPoint.setIsBeingWatched(value);
    }
}

