/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.test.pdf;

import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.IRangeSet;
import hep.aida.ref.pdf.FunctionConverter;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.test.pdf.AbstractPdfTestCase;
import java.util.Random;

public class UnbinnedGaussianFit
extends AbstractPdfTestCase {
    private ICloud1D c1 = this.histogramFactory().createCloud1D("Cloud 1D");

    public UnbinnedGaussianFit(String name) {
        super(name);
        Random r = new Random();
        for (int i = 0; i < 100000; ++i) {
            this.c1.fill(r.nextGaussian());
        }
    }

    public void testFit() {
        Gaussian g = new Gaussian("myGauss");
        IModelFunction gauss = FunctionConverter.getIModelFunction(g);
        IRangeSet r1 = gauss.normalizationRange(0);
        r1.excludeAll();
        r1.include(this.c1.lowerEdge(), this.c1.upperEdge());
        gauss.setParameter("mean", this.c1.mean());
        gauss.setParameter("sigma", this.c1.rms());
        IFitter gaussFit = this.fitFactory().createFitter("uml", "minuit", "noClone=true");
        long start = System.currentTimeMillis();
        IFitResult gaussFitResult = gaussFit.fit((IBaseHistogram)this.c1, (IFunction)gauss);
        long end = System.currentTimeMillis();
        long time = end - start;
        UnbinnedGaussianFit.assertEquals((double)this.c1.mean(), (double)g.getParameter("mean").value(), (double)0.001);
        UnbinnedGaussianFit.assertEquals((double)this.c1.rms(), (double)g.getParameter("sigma").value(), (double)0.002);
        UnbinnedGaussianFit.assertEquals((float)time, (float)6000.0f, (float)3000.0f);
    }
}

