/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.test.jaida;

import hep.aida.ref.AidaUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;

public class TestOptions
extends TestCase {
    public TestOptions(String testName) {
        super(testName);
    }

    public void testOptionsParsing() {
        String[] tests = new String[]{"a= b ;c = d ", "a=\"Some Options\",c= \"My , Funny Value\" ", "testCase", "  ", null, "username=,password=,sql=\"select * from Gooddata\",url=\"jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=C:\\Documents and Settings\\tonyj\\My Documents\\mq.mdb\",driver=sun.jdbc.odbc.JdbcOdbcDriver", "a=b, hep.aida.ref.sql.user=test"};
        int[] count = new int[]{2, 2, 1, 0, 0, 5, 2};
        block7: for (int i = 0; i < tests.length; ++i) {
            Map result = AidaUtils.parseOptions(tests[i]);
            TestOptions.assertEquals((int)result.size(), (int)count[i]);
            switch (i) {
                case 0: {
                    TestOptions.assertEquals(result.get("a"), (Object)"b");
                    TestOptions.assertEquals(result.get("c"), (Object)"d");
                    continue block7;
                }
                case 1: {
                    TestOptions.assertEquals(result.get("a"), (Object)"Some Options");
                    TestOptions.assertEquals(result.get("c"), (Object)"My , Funny Value");
                    continue block7;
                }
                case 2: {
                    TestOptions.assertEquals(result.get("testCase"), (Object)"true");
                    continue block7;
                }
                case 5: {
                    TestOptions.assertEquals(result.get("username"), (Object)"");
                    TestOptions.assertEquals(result.get("url"), (Object)"jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=C:\\Documents and Settings\\tonyj\\My Documents\\mq.mdb");
                    continue block7;
                }
                case 6: {
                    TestOptions.assertEquals(result.get("hep.aida.ref.sql.user"), (Object)"test");
                    continue block7;
                }
            }
        }
    }

    public void testOptionsParsing2() {
        Random r = new Random();
        int n = 1000;
        int max = 100;
        HashMap<String, String> in = new HashMap<String, String>();
        StringBuffer options = new StringBuffer(max * n);
        for (int i = 0; i < n; ++i) {
            int size = r.nextInt(max);
            StringBuffer buf = new StringBuffer(size);
            for (int j = 0; j < size; ++j) {
                char c = (char)(32 + r.nextInt(64));
                if (c == '\"') continue;
                buf.append(c);
            }
            in.put("key" + i, buf.toString());
            options.append("key");
            options.append(i);
            options.append("=\"");
            options.append(buf);
            options.append("\"");
            options.append(";");
        }
        Map out = AidaUtils.parseOptions(options.toString());
        TestOptions.assertEquals(in, (Object)out);
    }

    public void testOptionsParsing3() {
        String options = "annotation.xAxis=date, annotation.customOverlay=hep.aida.ref.plotter.adapter.TimeHistoryOverlay";
        String[] array = AidaUtils.parseString(options);
        TestOptions.assertEquals((int)array.length, (int)2);
        TestOptions.assertEquals((String)array[0], (String)"annotation.xAxis=date");
        TestOptions.assertEquals((String)array[1], (String)"annotation.customOverlay=hep.aida.ref.plotter.adapter.TimeHistoryOverlay");
        String path = "/hist/dir1/subdir/h11";
        String name = AidaUtils.parseName(path);
        String dir = AidaUtils.parseDirName(path);
        TestOptions.assertEquals((String)name, (String)"h11");
        TestOptions.assertEquals((String)dir, (String)"/hist/dir1/subdir/");
        path = "/dir0/";
        name = AidaUtils.parseName(path);
        dir = AidaUtils.parseDirName(path);
        TestOptions.assertEquals((String)name, (String)"");
        TestOptions.assertEquals((String)dir, (String)"/dir0/");
        path = "/hist1D";
        name = AidaUtils.parseName(path);
        dir = AidaUtils.parseDirName(path);
        TestOptions.assertEquals((String)name, (String)"hist1D");
        TestOptions.assertEquals((String)dir, (String)"/");
        path = "hist1D";
        name = AidaUtils.parseName(path);
        dir = AidaUtils.parseDirName(path);
        TestOptions.assertEquals((String)name, (String)"hist1D");
        TestOptions.assertEquals((String)dir, (String)"");
        path = "/hist/dir1/subdir/";
        name = AidaUtils.parseName(path);
        dir = AidaUtils.parseDirName(path);
        TestOptions.assertEquals((String)name, (String)"");
        TestOptions.assertEquals((String)dir, (String)"/hist/dir1/subdir/");
    }
}

