/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.root;

import hep.aida.IManagedObject;
import hep.aida.dev.IDevTree;
import hep.aida.dev.IOnDemandStore;
import hep.aida.ref.root.Converter;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.RootObject;
import hep.io.root.daemon.xrootd.XrootdStreamHandler;
import hep.io.root.interfaces.TDirectory;
import hep.io.root.interfaces.TKey;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

class XrootdStore
implements IOnDemandStore {
    private RootFileReader file;
    private boolean recursive;
    private boolean showAllCycles;
    private boolean useProxies;
    private static URL context;
    private static XrootdStreamHandler handler;
    private static boolean init;

    XrootdStore() {
    }

    private static void init() {
        try {
            context = new URL("http://www.freehep.org");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        handler = new XrootdStreamHandler();
        init = true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
    }

    @Override
    public void commit(IDevTree tree, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void read(IDevTree tree, Map options, boolean readOnly, boolean createNew) throws IOException {
        String storeName = tree.storeName();
        if (storeName.startsWith("xroot:")) {
            if (!init) {
                XrootdStore.init();
            }
            URL url = new URL(context, storeName, (URLStreamHandler)handler);
            this.file = new RootFileReader(url, options);
        } else {
            this.file = new RootFileReader(tree.storeName());
        }
        this.useProxies = this.toBoolean(options, "useProxies");
        this.recursive = this.toBoolean(options, "recursive");
        boolean bl = this.showAllCycles = this.toBoolean(options, "showallcycles") || this.toBoolean(options, "showAllCycles");
        if (this.recursive) {
            this.addEntries(tree, (TDirectory)this.file, "/");
        }
    }

    private boolean toBoolean(Map options, String key) {
        Object value = options.get(key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value.toString());
    }

    @Override
    public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (this.file == null) {
            throw new IOException("Root file is not open.");
        }
        RootFileReader folder = this.file;
        RootObject obj = null;
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.countTokens() > 0) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    obj = folder.getKey(token).getObject();
                }
                catch (RootClassNotFound x) {
                    throw new IOException("Root class not found: " + x.getClassName());
                }
                if (!(obj instanceof TDirectory)) {
                    throw new IllegalArgumentException("Path " + path + " does not point to a directory in the ROOT file " + tree.storeName());
                }
                folder = (TDirectory)obj;
            }
        }
        this.addEntries(tree, (TDirectory)folder, path);
    }

    private void addEntries(IDevTree tree, TDirectory dir, String path) throws IOException {
        if (this.showAllCycles) {
            int nKeys = dir.nKeys();
            for (int k = 0; k < nKeys; ++k) {
                this.addEntry(tree, path, dir.getKey(k));
            }
        } else {
            HashMap<String, TKey> map = new HashMap<String, TKey>();
            int nKeys = dir.nKeys();
            for (int k = 0; k < nKeys; ++k) {
                TKey key = dir.getKey(k);
                String name = key.getName();
                TKey oldKey = (TKey)map.get(name);
                if (oldKey != null && key.getCycle() <= oldKey.getCycle()) continue;
                map.put(name, key);
            }
            Iterator i = map.values().iterator();
            while (i.hasNext()) {
                this.addEntry(tree, path, (TKey)i.next());
            }
        }
        tree.hasBeenFilled(path);
    }

    private void addEntry(IDevTree tree, String path, TKey key) throws IOException {
        try {
            if (TDirectory.class.isAssignableFrom(key.getObjectClass().getJavaClass())) {
                String newPath = path.endsWith("/") ? path + key.getName() : path + "/" + key.getName();
                tree.mkdirs(newPath);
                if (this.recursive) {
                    this.addEntries(tree, (TDirectory)key.getObject(), newPath);
                }
            } else {
                IManagedObject im = Converter.convert(key, this.getName(key), this.useProxies);
                if (im != null) {
                    tree.add(path, im);
                }
            }
        }
        catch (RootClassNotFound x) {
            throw new IOException("Root class not found: " + x.getClassName());
        }
    }

    private String getName(TKey key) {
        return this.showAllCycles ? key.getName() + ";" + key.getCycle() : key.getName();
    }

    static {
        init = false;
    }
}

