/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.root;

import hep.aida.ITuple;
import hep.aida.ref.root.TLeafBColumn;
import hep.aida.ref.root.TLeafCColumn;
import hep.aida.ref.root.TLeafColumn;
import hep.aida.ref.root.TLeafDColumn;
import hep.aida.ref.root.TLeafFColumn;
import hep.aida.ref.root.TLeafFolderColumn;
import hep.aida.ref.root.TLeafIColumn;
import hep.aida.ref.root.TLeafLColumn;
import hep.aida.ref.root.TLeafObjectColumn;
import hep.aida.ref.tuple.ReadOnlyAbstractTuple;
import hep.io.root.RootClassNotFound;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafC;
import hep.io.root.interfaces.TLeafD;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.interfaces.TLeafL;
import hep.io.root.interfaces.TTree;
import java.io.IOException;
import org.freehep.util.Value;

class TTreeTuple
extends ReadOnlyAbstractTuple {
    private TKey key;
    private Value theValue;
    private TLeafColumn[] columns;
    private int nCol;

    TTreeTuple(TKey key, String name) {
        super(name, key.getTitle());
        this.key = key;
        this.nCol = this.tree().getLeaves().size();
        this.columns = new TLeafColumn[this.nCol];
        this.theValue = new Value();
        TLeafFolderColumn subTuple = null;
        TLeafI lastDim = null;
        int n = 0;
        for (int i = 0; i < this.nCol; ++i) {
            TLeaf leaf = (TLeaf)this.tree().getLeaves().get(i);
            int nDim = leaf.getArrayDim();
            if (nDim == 0) {
                if (leaf instanceof TLeafI) {
                    this.columns[n++] = new TLeafIColumn((TLeafI)leaf);
                    continue;
                }
                if (leaf instanceof TLeafL) {
                    this.columns[n++] = new TLeafLColumn((TLeafL)leaf);
                    continue;
                }
                if (leaf instanceof TLeafF) {
                    this.columns[n++] = new TLeafFColumn((TLeafF)leaf);
                    continue;
                }
                if (leaf instanceof TLeafD) {
                    this.columns[n++] = new TLeafDColumn((TLeafD)leaf);
                    continue;
                }
                if (leaf instanceof TLeafB) {
                    this.columns[n++] = new TLeafBColumn((TLeafB)leaf);
                    continue;
                }
                if (leaf instanceof TLeafC) {
                    this.columns[n++] = new TLeafCColumn((TLeafC)leaf);
                    continue;
                }
                System.out.println("Ignored column " + leaf.getName() + " of type " + leaf.getClass());
                continue;
            }
            TLeafI dim = (TLeafI)leaf.getLeafCount();
            if (dim == null) {
                this.columns[n++] = new TLeafObjectColumn(leaf);
                continue;
            }
            if (dim == lastDim) {
                subTuple.addColumn(leaf);
                continue;
            }
            subTuple = new TLeafFolderColumn(dim);
            this.columns[n++] = subTuple;
            subTuple.addColumn(leaf);
            lastDim = dim;
        }
        this.nCol = n;
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public boolean providesColumnDefaultValues() {
        return false;
    }

    @Override
    public void columnValue(int column, Value v) {
        this.columns[column].getValue(this.getRow(), v);
    }

    @Override
    public ITuple findTuple(int col) {
        this.columns[col].getValue(this.getRow(), this.theValue);
        return (ITuple)this.theValue.getObject();
    }

    @Override
    public double columnMax(int index) throws IllegalArgumentException {
        this.columns[index].maxValue(this.theValue);
        return this.theValue.getDouble();
    }

    @Override
    public double columnMean(int index) throws IllegalArgumentException {
        this.columns[index].meanValue(this.theValue);
        return this.theValue.getDouble();
    }

    @Override
    public double columnMin(int index) throws IllegalArgumentException {
        this.columns[index].minValue(this.theValue);
        return this.theValue.getDouble();
    }

    @Override
    public String columnName(int index) throws IllegalArgumentException {
        return this.columns[index].name();
    }

    @Override
    public double columnRms(int index) throws IllegalArgumentException {
        this.columns[index].rmsValue(this.theValue);
        return this.theValue.getDouble();
    }

    @Override
    public Class columnType(int index) throws IllegalArgumentException {
        return this.columns[index].type();
    }

    @Override
    public int columns() {
        return this.nCol;
    }

    @Override
    public int findColumn(String name) throws IllegalArgumentException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].name().equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown column " + name);
    }

    @Override
    public int rows() {
        return (int)this.tree().getEntries();
    }

    @Override
    public boolean supportsMultipleCursors() {
        return true;
    }

    @Override
    public boolean supportsRandomAccess() {
        return true;
    }

    private TTree tree() {
        try {
            return (TTree)this.key.getObject();
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Root Class Not Found " + x.getClassName(), x);
        }
        catch (IOException x) {
            throw new RuntimeException("IOException reading root file", x);
        }
    }

    @Override
    public String columnDefaultString(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object columnDefaultValue(int index) {
        throw new UnsupportedOperationException();
    }
}

