/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.client;

import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.rmi.client.RmiClientImpl;
import hep.aida.ref.remote.rmi.interfaces.RmiServant;
import hep.aida.ref.remote.rmi.interfaces.RmiServer;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Map;

public class RmiRemoteServer
implements AidaTreeServer {
    private RmiServer server;
    private Map hash;

    public RmiRemoteServer(RmiServer server) {
        this.server = server;
        this.hash = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Map map = this.hash;
        synchronized (map) {
            if (!this.hash.isEmpty()) {
                for (Object clientRef : this.hash.keySet()) {
                    this.unRegisterClient(clientRef);
                }
                this.hash.clear();
            }
        }
        this.hash = null;
    }

    private boolean checkClient(Object key) {
        boolean ok = false;
        if (this.hash.containsKey(key)) {
            ok = true;
        }
        return ok;
    }

    private void registerClient(Object key, RmiClientImpl rmiClient) {
        this.hash.put(key, rmiClient);
    }

    private boolean unRegisterClient(Object key) {
        RmiClientImpl rmiClient = (RmiClientImpl)this.hash.remove(key);
        if (rmiClient == null) {
            return false;
        }
        rmiClient.disconnect();
        return true;
    }

    @Override
    public AidaTreeServant connectDuplex(AidaTreeClient aidaClient) {
        if (this.checkClient(aidaClient)) {
            String clientRef = aidaClient.toString();
            throw new RemoteConnectionException("This client is already connected. Please disconnect first.\nClient: " + clientRef);
        }
        boolean duplex = true;
        RmiClientImpl aidaServant = null;
        RmiServant rmiServant = null;
        try {
            aidaServant = new RmiClientImpl(aidaClient, duplex);
            rmiServant = this.server.connectDuplex(aidaServant);
        }
        catch (RemoteConnectionException re) {
            throw re;
        }
        catch (Exception re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        aidaServant.setRmiServant(rmiServant);
        this.registerClient(aidaClient, aidaServant);
        return aidaServant;
    }

    @Override
    public AidaTreeServant connectNonDuplex(String clientID) {
        if (this.checkClient(clientID)) {
            throw new RemoteConnectionException("This client is already connected. Please disconnect first.\nClient: " + clientID);
        }
        boolean duplex = false;
        RmiServant rmiServant = null;
        RmiClientImpl aidaServant = null;
        try {
            rmiServant = this.server.connectNonDuplex(clientID);
            aidaServant = new RmiClientImpl(rmiServant, duplex);
        }
        catch (Exception e) {
            throw new RemoteConnectionException(e.getMessage(), e);
        }
        this.registerClient(clientID, aidaServant);
        return aidaServant;
    }

    @Override
    public boolean disconnectDuplex(AidaTreeClient aidaClient) {
        if (!this.checkClient(aidaClient)) {
            String clientRef = aidaClient.toString();
            throw new RemoteConnectionException("This client is not connected.\nClient: " + clientRef);
        }
        RmiClientImpl rmiClient = (RmiClientImpl)this.hash.get(aidaClient);
        boolean ok = false;
        try {
            ok = this.server.disconnectDuplex(rmiClient);
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        return this.unRegisterClient(aidaClient) && ok;
    }

    @Override
    public boolean disconnectNonDuplex(String clientID) {
        if (!this.checkClient(clientID)) {
            throw new RemoteConnectionException("This client is not connected.\nClient: " + clientID);
        }
        RmiClientImpl rmiClient = (RmiClientImpl)this.hash.get(clientID);
        boolean ok = false;
        try {
            ok = this.server.disconnectNonDuplex(clientID);
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        return this.unRegisterClient(clientID) && ok;
    }

    @Override
    public boolean supportDuplexMode() {
        boolean result = false;
        try {
            result = this.server.supportDuplexMode();
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        return result;
    }

    @Override
    public String treeName() {
        String result = null;
        try {
            result = this.server.treeName();
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        return result;
    }
}

