/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.corba;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IHistogram1D;
import hep.aida.IManagedObject;
import hep.aida.IPlotter;
import hep.aida.ITreeFactory;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.AnalysisFactory;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.RemoteUpdatableQueue;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.corba.generated.EventFlags;
import hep.aida.ref.remote.corba.generated.EventID;
import hep.aida.ref.remote.corba.generated.EventStruct;
import hep.aida.ref.remote.corba.generated.TreeClient;
import hep.aida.ref.remote.corba.generated.TreeClientHelper;
import hep.aida.ref.remote.corba.generated.TreeClientPOA;
import hep.aida.ref.remote.corba.generated.TreeServant;
import hep.aida.ref.remote.corba.generated.TreeServer;
import hep.aida.ref.remote.corba.generated.TreeServerHelper;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.tree.Tree;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Random;
import java.util.StringTokenizer;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class CorbaTreeClientImpl
extends TreeClientPOA
implements AidaTreeClient,
Runnable {
    protected TreeServer server;
    protected TreeServant servant;
    protected IDevMutableStore store;
    protected RemoteUpdatableQueue queue;
    protected boolean duplex;
    protected boolean isConnected;
    protected long updateInterval;
    protected boolean keepUpdating;
    protected String clientID;
    protected ORB orb;
    protected POA rootPOA;
    protected TreeClient treeClient;
    protected String ior;
    protected String nsName;

    public CorbaTreeClientImpl() {
        this(null, null, null);
    }

    public CorbaTreeClientImpl(IDevMutableStore store, String ior) {
        this(store, ior, null);
    }

    public CorbaTreeClientImpl(IDevMutableStore store, String ior, String nsName) {
        this.init();
        this.store = store;
        this.ior = ior.trim();
        this.nsName = nsName;
        if (nsName != null) {
            // empty if block
        }
        this.duplex = true;
        this.keepUpdating = !this.duplex;
        System.out.println("Created CorbaTreeClientImpl with nsName=" + nsName + ", ior=" + ior);
    }

    protected void init() {
        this.server = null;
        this.servant = null;
        this.isConnected = false;
        this.updateInterval = 2000L;
        this.clientID = "CorbaTreeClient_" + System.currentTimeMillis();
    }

    protected TreeServer getServer() {
        TreeServer server = null;
        if (this.nsName == null) {
            try {
                Object objRef = this.orb.string_to_object(this.ior);
                server = TreeServerHelper.narrow((Object)objRef);
                boolean supportsDuplex = server.supportDuplexMode();
                System.out.println("\nTreeServer support for the Duplex Mode: " + supportsDuplex);
            }
            catch (Exception t) {
                t.printStackTrace();
                server = null;
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.nsName, "/");
            int nTokens = tokenizer.countTokens();
            NameComponent[] pathName = new NameComponent[nTokens];
            for (int i = 0; i < nTokens; ++i) {
                pathName[i] = new NameComponent(tokenizer.nextToken(), "");
            }
            try {
                Object objRef = this.orb.string_to_object(this.ior);
                NamingContext nc = NamingContextHelper.narrow((Object)objRef);
                Object serverObject = nc.resolve(pathName);
                server = TreeServerHelper.narrow((Object)objRef);
            }
            catch (Exception e) {
                e.printStackTrace();
                server = null;
            }
        }
        return server;
    }

    public synchronized void setUpdateTime(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public synchronized void setDuplex(boolean duplex) {
        if (this.isConnected) {
            System.out.println("WARNING: Client is connected, can not change DUPLEX settings. Please disconnect first");
            return;
        }
        this.duplex = duplex;
        this.keepUpdating = !duplex;
        System.out.println("CorbaTreeClientImpl.setDuplex " + duplex);
    }

    protected void connectDuplex() throws RemoteConnectionException {
        try {
            Object rootRef = this.orb.resolve_initial_references("RootPOA");
            this.rootPOA = POAHelper.narrow((Object)rootRef);
            this.rootPOA.the_POAManager().activate();
            Object obj = this.rootPOA.servant_to_reference((Servant)this);
            String ref = this.orb.object_to_string(obj);
            System.out.println("TreeClient IOR String: \n\t" + ref);
            this.treeClient = TreeClientHelper.narrow((Object)obj);
            this.servant = this.server.connectDuplex(this.treeClient);
        }
        catch (RemoteConnectionException ae) {
            throw ae;
        }
        catch (Exception e) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            throw new RemoteConnectionException("Can not connect to TreeServer: " + name, e);
        }
        if (this.servant == null) {
            throw new RemoteConnectionException("Can not retrieve Duplex TreeServant from: " + this.server.treeName());
        }
        new Thread(this).start();
        this.isConnected = true;
    }

    protected void connectNonDuplex() throws RemoteConnectionException {
        this.servant = this.server.connectNonDuplex(this.clientID);
        if (this.servant == null) {
            throw new RemoteConnectionException("Can not retrieve non-Duplex TreeServant from: " + this.server.treeName());
        }
        new Thread(this).start();
        this.isConnected = true;
    }

    public void setValid(String path) {
        this.servant.setValid(new String[]{path});
    }

    public String[] listObjectNames(String path) throws IllegalArgumentException {
        if (!this.isConnected) {
            System.out.println("WARNING: Client is not connected.");
            return null;
        }
        String[] names = this.servant.listObjectNames(path);
        return names;
    }

    public String[] listObjectTypes(String path) throws IllegalArgumentException {
        if (!this.isConnected) {
            System.out.println("WARNING: Client is not connected.");
            return null;
        }
        String[] types = this.servant.listObjectTypes(path);
        return types;
    }

    public java.lang.Object find(String path) throws IllegalArgumentException {
        if (!this.isConnected) {
            System.out.println("WARNING: Client is not connected.");
            return null;
        }
        Any data = this.servant.find(path);
        return data;
    }

    public void stateChanged(EventStruct[] events) {
        if (events != null && events.length != 0) {
            AidaUpdateEvent[] aidaEvents = new RemoteUpdateEvent[events.length];
            String[] paths = new String[events.length];
            for (int i = 0; i < events.length; ++i) {
                String path = events[i].path;
                boolean folder = events[i].flags == EventFlags.FOLDER_MASK;
                String type = events[i].nodeType;
                if (folder) {
                    type = "dir";
                }
                int id = -1;
                if (events[i].id == EventID.NODE_UPDATED) {
                    id = 0;
                } else if (events[i].id == EventID.NODE_ADDED) {
                    id = 1;
                } else if (events[i].id == EventID.NODE_DELETED) {
                    id = 2;
                }
                aidaEvents[i] = new RemoteUpdateEvent(id, path, type);
                paths[i] = path;
            }
            this.stateChanged(aidaEvents);
        }
    }

    @Override
    public void stateChanged(AidaUpdateEvent[] events) {
        if (events != null && events.length > 0) {
            for (int i = 0; i < events.length; ++i) {
                this.queue.schedule((java.lang.Object)this.store, events[i]);
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean connect() {
        if (this.isConnected) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            System.out.println("WARNING: Already connected to TreeServer: " + name + ". No action taken.");
            return false;
        }
        String[] orbArgs = new String[]{};
        this.orb = ORB.init((String[])orbArgs, null);
        this.server = this.getServer();
        System.out.println("Connecting:  duplex=" + this.duplex);
        if (this.server == null) {
            throw new RemoteConnectionException("Can not get reference to TreeServer.");
        }
        this.queue = new RemoteUpdatableQueue();
        try {
            if (this.duplex) {
                boolean supportsDuplex = this.server.supportDuplexMode();
                if (!supportsDuplex) {
                    System.out.println("Warning: TreeServer \"" + this.server.treeName() + "\" does not support DUPLEX mode. \nWill try to connect using non-DUPLEX mode.");
                    this.duplex = false;
                    this.keepUpdating = !this.duplex;
                    this.connectNonDuplex();
                } else {
                    this.connectDuplex();
                }
            } else {
                this.connectNonDuplex();
            }
        }
        catch (RemoteConnectionException ae) {
            throw ae;
        }
        catch (Exception e) {
            String name = "null";
            if (this.server != null) {
                name = this.server.treeName();
            }
            throw new RemoteConnectionException("Can not connect to TreeServer: " + name, e);
        }
        return true;
    }

    public boolean disconnect() {
        System.out.print("\nCorbaTreeClientImpl.disconnect: for Client=" + this.clientID + ", isConnected=" + this.isConnected);
        this.queue.close();
        this.queue = null;
        if (!this.isConnected) {
            this.keepUpdating = false;
            this.server = null;
            this.servant = null;
            try {
                this.orb.shutdown(true);
                this.orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        boolean status = true;
        this.keepUpdating = false;
        if (this.server != null) {
            status = this.duplex ? this.server.disconnectDuplex(this.treeClient) : this.server.disconnectNonDuplex(this.clientID);
        }
        this.server = null;
        this.servant = null;
        System.out.print(" Done.\n");
        System.out.println("Shutting down CORBA Client ... ");
        try {
            this.orb.shutdown(true);
            this.orb.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.orb = null;
        this.rootPOA = null;
        System.out.println(" Done!\n");
        return status;
    }

    @Override
    public void run() {
        if (this.duplex) {
            this.orb.run();
        } else {
            while (this.keepUpdating) {
                if (this.isConnected) {
                    EventStruct[] events = this.servant.updates();
                    System.out.println("BasicTreeClient.run: GOT " + events.length + " events.");
                    if (events != null && events.length > 0) {
                        this.stateChanged(events);
                    }
                }
                try {
                    Thread.sleep(this.updateInterval);
                }
                catch (InterruptedException ie) {
                    System.out.println("AidaTreeClient non-DUPLEX Update Thread InterruptedException.");
                    ie.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        Random r = new Random();
        AnalysisFactory af = new AnalysisFactory();
        ITreeFactory tf = af.createTreeFactory();
        Tree clientTree = null;
        IPlotter plotter = af.createPlotterFactory().create("Plot");
        plotter.createRegions(2, 2, 0);
        plotter.show();
        try {
            clientTree = (Tree)tf.create("CORBA_Test", "corba", true, false, "iorFileURL=http://www.slac.stanford.edu/~serbo/jas3/TreeServer.ior");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
        PrintStream out = System.out;
        String menuMain = "\n\n===============================\n cd <path> \n pwd \n ls\n find <path> \n plot <path> <region> \n check <path> \n mkdirs <path> \n Q \n-------------------------------\nUser Input => ";
        while (true) {
            try {
                while (true) {
                    IManagedObject mo;
                    out.print(menuMain);
                    String input = console.readLine();
                    StringTokenizer st = new StringTokenizer(input.trim(), " ");
                    String[] tokens = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        tokens[i] = st.nextToken().trim();
                        ++i;
                    }
                    if (tokens[0].startsWith("cd")) {
                        clientTree.cd(tokens[1]);
                        continue;
                    }
                    if (tokens[0].startsWith("pwd")) {
                        out.println(clientTree.pwd());
                        continue;
                    }
                    if (tokens[0].startsWith("ls")) {
                        clientTree.ls();
                        continue;
                    }
                    if (tokens[0].startsWith("find")) {
                        mo = clientTree.find(tokens[1]);
                        out.println("Found: name=" + mo.name() + ",  mo=" + mo);
                        continue;
                    }
                    if (tokens[0].startsWith("check")) {
                        clientTree.checkForChildren(tokens[1]);
                        continue;
                    }
                    if (tokens[0].startsWith("mkdirs")) {
                        clientTree.mkdirs(tokens[1]);
                        continue;
                    }
                    if (tokens[0].startsWith("plot")) {
                        mo = clientTree.find(tokens[1]);
                        if (mo instanceof IHistogram1D) {
                            plotter.region(Integer.parseInt(tokens[2])).plot((IBaseHistogram)((IHistogram1D)mo));
                        } else if (mo instanceof IDataPointSet) {
                            plotter.region(Integer.parseInt(tokens[2])).plot((IDataPointSet)mo);
                        }
                        plotter.show();
                        continue;
                    }
                    if (!input.toLowerCase().startsWith("q")) continue;
                    clientTree.close();
                    System.exit(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

