/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.IPlottable;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteTableEvent;
import hep.aida.ref.remote.interfaces.ITable;
import java.util.EventObject;

public class RemoteTable
extends RemoteManagedObject
implements ITable,
IPlottable {
    private Annotation annotation = null;
    private int columns;
    private int rows;
    private Object[][] values;
    private String[] labels;

    public RemoteTable(String name) {
        this(null, name);
    }

    public RemoteTable(IDevMutableStore store, String name) {
        this(store, name, name, 1, 1);
    }

    public RemoteTable(IDevMutableStore store, String name, String title, int rows, int columns) {
        super(name);
        this.aidaType = "hep.aida.ref.remote.interfaces.ITable";
        this.store = store;
        this.columns = columns;
        this.rows = rows;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
    }

    @Override
    protected EventObject createEvent() {
        return new RemoteTableEvent(this);
    }

    @Override
    public void setTreeFolder(String treeFolder) {
        super.setTreeFolder(treeFolder);
        boolean flbl = this.annotation.isFillable();
        if (!flbl) {
            this.annotation.setFillable(true);
        }
        if (this.annotation.hasKey(Annotation.fullPathKey)) {
            this.annotation.setValue(Annotation.fullPathKey, this.treePath);
        } else {
            this.annotation.addItem(Annotation.fullPathKey, this.treePath, true);
        }
        if (!flbl) {
            this.annotation.setFillable(false);
        }
    }

    public Object[][] getValues() {
        return this.values;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setValues(Object[][] values) {
        this.values = values;
        this.rows = values.length;
        this.columns = values[0].length;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    @Override
    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.annotation;
    }

    @Override
    public int columnCount() {
        this.makeSureDataIsValid();
        if (this.values == null) {
            return 1;
        }
        return this.columns;
    }

    @Override
    public int rowCount() {
        this.makeSureDataIsValid();
        if (this.values == null) {
            return 1;
        }
        return this.rows;
    }

    @Override
    public String title() {
        return this.annotation.value(Annotation.titleKey);
    }

    @Override
    public Object valueAt(int row, int column) {
        this.makeSureDataIsValid();
        if (this.values == null) {
            return "No Data Available";
        }
        return this.values[row][column];
    }

    @Override
    public void setTitle(String title) throws IllegalArgumentException {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.annotation.setFillable(true);
        this.annotation.setValue(Annotation.titleKey, title);
        this.annotation.setFillable(false);
    }

    @Override
    public String columnName(int column) {
        this.makeSureDataIsValid();
        if (this.labels == null) {
            return String.valueOf(column);
        }
        return this.labels[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        throw new ReadOnlyException();
    }
}

