/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.dev.IDevTree;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.DataPointSetEvent;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.remote.RemoteServerQueue;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.tree.Tree;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteServant
implements AidaTreeServant,
AIDAListener {
    private IDevTree tree;
    private AidaTreeClient client;
    private String clientID;
    private boolean duplex;
    protected boolean blocking = false;
    private boolean appendAxisType;
    private boolean keepRunning;
    private Vector sources;
    private Hashtable hash;
    private RemoteServerQueue eventQueue;
    protected boolean useValidation;
    protected Logger remoteLogger;

    public RemoteServant(IDevTree tree, String clientID) {
        this.tree = tree;
        this.clientID = clientID;
        this.duplex = false;
        this.appendAxisType = false;
        this.eventQueue = new RemoteServerQueue();
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.init();
    }

    public RemoteServant(IDevTree tree, AidaTreeClient client) {
        this.tree = tree;
        this.client = client;
        this.duplex = true;
        this.appendAxisType = false;
        this.eventQueue = new RemoteServerQueue(client);
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.init();
    }

    public void setAppendAxisType(boolean a) {
        this.appendAxisType = a;
    }

    public boolean getAppendAxisType() {
        return this.appendAxisType;
    }

    public void setBlocking(boolean b) {
        this.blocking = b;
        this.eventQueue.setBlocking(b);
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    protected void init() {
        this.sources = new Vector();
        this.hash = new Hashtable();
        this.useValidation = true;
        this.keepRunning = this.duplex;
        Object lock = this.tree.getLock();
        if (lock != null) {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).addListener(this);
                this.sources.add(this.tree);
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
            if (this.tree instanceof Tree) {
                ((Tree)this.tree).setFolderIsWatched("/", true);
            }
        } else {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).addListener(this);
                this.sources.add(this.tree);
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
            if (this.tree instanceof Tree) {
                ((Tree)this.tree).setFolderIsWatched("/", true);
            }
        }
    }

    public synchronized void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RemoteServant remoteServant = this;
        synchronized (remoteServant) {
            this.remoteLogger.fine("\n\tClosing RemoteServant ... ");
            this.keepRunning = false;
            if (this.eventQueue != null) {
                this.eventQueue.close();
            }
            Object lock = null;
            if (this.tree != null) {
                this.tree.getLock();
            }
            if (lock != null) {
                if (this.tree instanceof IsObservable) {
                    try {
                        ((IsObservable)((Object)this.tree)).removeListener(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.sources != null) {
                    for (int i = 0; i < this.sources.size(); ++i) {
                        try {
                            IsObservable o = (IsObservable)this.sources.get(i);
                            if (o == null) continue;
                            o.removeListener(this);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                if (this.tree instanceof IsObservable) {
                    try {
                        ((IsObservable)((Object)this.tree)).removeListener(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.sources != null) {
                    for (int i = 0; i < this.sources.size(); ++i) {
                        try {
                            IsObservable o = (IsObservable)this.sources.get(i);
                            if (o == null) continue;
                            o.removeListener(this);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.sources != null) {
            this.sources.clear();
        }
        if (this.hash != null) {
            this.hash.clear();
        }
        this.sources = null;
        this.hash = null;
        this.tree = null;
        this.client = null;
        this.eventQueue = null;
        this.remoteLogger.fine("  ... RemoteServant is closed\n");
    }

    public void setValid(String path) {
        this.remoteLogger.finest("RemoteServant.setValid for path=" + path);
        if (path == null || path.equals("") || path.equals("/")) {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
        } else {
            IManagedObject mo = this.tree.find(path);
            if (!this.sources.contains(mo) && mo instanceof IsObservable) {
                ((IsObservable)mo).addListener(this);
                this.sources.add(mo);
            }
            if (mo instanceof IsObservable) {
                ((IsObservable)mo).setValid(this);
            }
        }
    }

    @Override
    public Object find(String path) {
        this.remoteLogger.finest("RemoteServant.find for path=" + path);
        IManagedObject mo = this.tree.find(path);
        if (mo instanceof IsObservable && !this.sources.contains((IsObservable)mo)) {
            ((IsObservable)mo).addListener(this);
            this.sources.add((IsObservable)mo);
            this.hash.put(path, mo);
            if (!this.useValidation) {
                ((IsObservable)mo).setValid(this);
            }
        }
        this.remoteLogger.finest("RemoteServant.find for path=" + path + ",  found MO=" + mo.toString());
        return mo;
    }

    @Override
    public String[] listObjectNames(String path, boolean recursive) {
        this.remoteLogger.finest("RemoteServant.listObjectNames for path=" + path);
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched(path, true);
        }
        String[] list = this.tree.listObjectNames(path, recursive);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listObjectTypes(String path, boolean recursive) {
        this.remoteLogger.finest("RemoteServant.listObjectTypes for path=" + path + ",  appendAxisType=" + this.appendAxisType);
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched(path, true);
        }
        String[] names = this.tree.listObjectNames(path, recursive);
        String[] list = this.tree.listObjectTypes(path, recursive);
        if (list == null || list.length == 0) {
            return list;
        }
        if (this.tree instanceof Tree) {
            Tree tTree = (Tree)this.tree;
            for (int i = 0; i < names.length; ++i) {
                String objPath = names[i];
                IManagedObject mo = tTree.findObject(objPath);
                if (!this.appendAxisType || list[i].equalsIgnoreCase("dir")) continue;
                String xType = "double";
                String tmp = null;
                if (mo instanceof ManagedObject) {
                    IManagedObject iManagedObject = mo;
                    synchronized (iManagedObject) {
                        boolean isFillable = false;
                        boolean isAnnotationFillable = false;
                        Annotation an = null;
                        isFillable = ((ManagedObject)mo).isFillable();
                        if (!isFillable) {
                            ((ManagedObject)mo).setFillable(true);
                        }
                        if (mo instanceof IBaseHistogram) {
                            an = (Annotation)((IBaseHistogram)mo).annotation();
                        } else if (mo instanceof IDataPointSet) {
                            an = (Annotation)((IDataPointSet)mo).annotation();
                        }
                        if (an != null) {
                            isAnnotationFillable = an.isFillable();
                            if (!isAnnotationFillable) {
                                an.setFillable(true);
                            }
                            try {
                                tmp = an.value("xAxisType");
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                            an.setFillable(isAnnotationFillable);
                        }
                        ((ManagedObject)mo).setFillable(isFillable);
                    }
                }
                if (mo != null) {
                    IAnnotation an = null;
                    if (mo instanceof IBaseHistogram) {
                        an = ((IBaseHistogram)mo).annotation();
                    } else if (mo instanceof IDataPointSet) {
                        an = ((IDataPointSet)mo).annotation();
                    }
                    try {
                        tmp = an.value("xAxisType");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (tmp == null || tmp.trim().equals("")) continue;
                xType = tmp;
                list[i] = list[i] + ":" + xType;
            }
        }
        return list;
    }

    @Override
    public void setValid(String[] path) {
        if (path != null && path.length != 0) {
            for (int i = 0; i < path.length; ++i) {
                this.setValid(path[i]);
            }
        }
    }

    @Override
    public AidaUpdateEvent[] updates() {
        this.remoteLogger.finest("RemoteServant.updates");
        AidaUpdateEvent[] events = new AidaUpdateEvent[]{};
        if (this.eventQueue != null) {
            events = this.eventQueue.getEvents();
        }
        this.remoteLogger.finest("RemoteServant.updates gotEvents=" + events.length);
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(EventObject ev) {
        IManagedObject path;
        this.remoteLogger.finest("RemoteServant: got   Event: " + ev.toString());
        RemoteUpdateEvent event = null;
        int id = -1;
        String pathString = "";
        String nodeType = "null";
        String xAxisType = "double";
        IManagedObject mo = null;
        if (ev instanceof AidaUpdateEvent) {
            String tmp;
            String nodeTypeString;
            AidaUpdateEvent aev = (AidaUpdateEvent)((Object)ev);
            id = aev.id();
            pathString = aev.path();
            nodeType = nodeTypeString = aev.nodeType();
            xAxisType = "double";
            int indexT = nodeTypeString.lastIndexOf(":");
            if (indexT > 0) {
                nodeType = nodeTypeString.substring(0, indexT);
                String tmpType = nodeTypeString.substring(indexT + 1);
                if (tmpType != null && !tmpType.equals("")) {
                    xAxisType = tmpType;
                }
            } else if (event instanceof RemoteUpdateEvent && (tmp = ((RemoteUpdateEvent)event).getXAxisType()) != null) {
                xAxisType = tmp;
            }
        } else if (ev instanceof TreeEvent) {
            TreeEvent tev = (TreeEvent)ev;
            if (tev.getType() != null) {
                nodeType = tev.getType().getName();
            }
            if (tev.getFlags() == 1) {
                nodeType = "dir";
            }
            if ((path = tev.getPath()) != null) {
                for (int i = 0; i < ((String[])path).length; ++i) {
                    pathString = pathString + "/" + path[i];
                }
            }
            if (tev.getID() == 1) {
                id = 1;
                try {
                    if (!nodeType.equalsIgnoreCase("dir")) {
                        IManagedObject tmpMo = ((ITree)ev.getSource()).find(pathString);
                        nodeType = tmpMo.type();
                    }
                }
                catch (Exception ex) {
                    this.remoteLogger.log(Level.INFO, "RemoteServant.stateChanged: Exception while setting type:" + nodeType + " \n\t" + ex.getMessage());
                    this.remoteLogger.log(Level.FINEST, "", ex);
                }
            } else if (tev.getID() == 2) {
                id = 2;
            } else if (tev.getID() == 5) {
                id = 3;
                nodeType = "dir";
            }
        } else if (ev instanceof HistogramEvent) {
            mo = (IManagedObject)ev.getSource();
        } else if (ev instanceof DataPointSetEvent) {
            mo = (IManagedObject)ev.getSource();
        } else {
            this.remoteLogger.fine("RemoteServant.stateChanged Unknown Event: " + ev);
            return;
        }
        if (mo != null) {
            pathString = this.tree.findPath(mo);
            id = 0;
            nodeType = mo.type();
        }
        if (!nodeType.equalsIgnoreCase("dir") && pathString.endsWith("/")) {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        if (nodeType.equalsIgnoreCase("dir") && !pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        if (id == 1) {
            if (!nodeType.equalsIgnoreCase("dir") && mo != null) {
                String tmp = null;
                if (mo instanceof ManagedObject) {
                    path = mo;
                    synchronized (path) {
                        boolean isFillable = false;
                        boolean isAnnotationFillable = false;
                        Annotation an = null;
                        isFillable = ((ManagedObject)mo).isFillable();
                        if (!isFillable) {
                            ((ManagedObject)mo).setFillable(true);
                        }
                        if (mo instanceof IBaseHistogram) {
                            an = (Annotation)((IBaseHistogram)mo).annotation();
                        } else if (mo instanceof IDataPointSet) {
                            an = (Annotation)((IDataPointSet)mo).annotation();
                        }
                        if (an != null) {
                            isAnnotationFillable = an.isFillable();
                            if (!isAnnotationFillable) {
                                an.setFillable(true);
                            }
                            try {
                                tmp = an.value("xAxisType");
                            }
                            catch (IllegalArgumentException e) {
                                // empty catch block
                            }
                            an.setFillable(isAnnotationFillable);
                        }
                        ((ManagedObject)mo).setFillable(isFillable);
                    }
                }
                if (mo != null) {
                    IAnnotation an = null;
                    if (mo instanceof IBaseHistogram) {
                        an = ((IBaseHistogram)mo).annotation();
                    } else if (mo instanceof IDataPointSet) {
                        an = ((IDataPointSet)mo).annotation();
                    }
                    try {
                        tmp = an.value("xAxisType");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (tmp != null && !tmp.trim().equals("")) {
                    xAxisType = tmp;
                }
            }
        } else if (id == 2) {
            if (nodeType.equalsIgnoreCase("dir")) {
                Enumeration en = this.hash.keys();
                while (en.hasMoreElements()) {
                    String tmpPath = (String)en.nextElement();
                    if (!tmpPath.startsWith(pathString)) continue;
                    IsObservable o = (IsObservable)this.hash.remove(pathString);
                    if (mo == null) continue;
                    o.removeListener(this);
                    this.sources.remove(o);
                }
            } else {
                IsObservable o = (IsObservable)this.hash.remove(pathString);
                if (mo != null) {
                    o.removeListener(this);
                    this.sources.remove(o);
                }
            }
        }
        if (id < 0) {
            this.remoteLogger.fine("RemoteServant.stateChanged wrong event ID=" + id);
            return;
        }
        if (!this.useValidation && this.tree instanceof IsObservable) {
            ((IsObservable)((Object)this.tree)).setValid(this);
        }
        this.remoteLogger.finest("RemoteServant: process Event: id = " + id + ",  path = " + pathString + ",  type = " + nodeType + ",  xAxisType=" + xAxisType);
        event = new RemoteUpdateEvent(id, pathString, nodeType, xAxisType);
        this.eventQueue.schedule(event);
    }
}

