/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.IPlotterFactory;
import hep.aida.IPlotterStyle;
import hep.aida.ref.plotter.PlotterFactory;
import hep.aida.ref.plotter.PlotterStyle;
import hep.aida.ref.plotter.style.registry.IGlobalIndexProvider;
import hep.aida.ref.plotter.style.registry.IPlotterState;
import hep.aida.ref.plotter.style.registry.IStyleRegistry;
import hep.aida.ref.plotter.style.registry.IStyleRule;
import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.StyleStoreXMLReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freehep.util.FreeHEPLookup;

public class StyleRegistry
implements IStyleRegistry,
IGlobalIndexProvider {
    public static String systemStoreProperty = "hep.aida.ref.plotter.style.registry.system.store";
    public static String groupStoreProperty = "hep.aida.ref.plotter.style.registry.group.store";
    public static String userStoreProperty = "hep.aida.ref.plotter.style.registry.user.store";
    private static String systemStoreFile = "SystemStyleStore.xml";
    private static StyleRegistry registry;
    private IPlotterFactory pf;
    private List stores = new ArrayList(10);
    private Map categories = new HashMap(5);
    private Object lock = new Object();
    private int globalIndex = 0;

    public static StyleRegistry getStyleRegistry() {
        if (registry == null) {
            registry = new StyleRegistry();
        }
        return registry;
    }

    private StyleRegistry() {
        IStyleStore store;
        InputStream stream;
        String systemFile = System.getProperty(systemStoreProperty, systemStoreFile);
        String groupFile = System.getProperty(groupStoreProperty, null);
        String userFile = System.getProperty(userStoreProperty, null);
        try {
            stream = this.getClass().getResourceAsStream(systemFile);
            IStyleStore systemStore = StyleStoreXMLReader.restoreFromStream(stream);
            this.addStore(systemStore);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (groupFile != null && !groupFile.trim().equals("")) {
            try {
                stream = this.getClass().getResourceAsStream(groupFile);
                store = StyleStoreXMLReader.restoreFromStream(stream);
                this.addStore(store);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (userFile != null && !userFile.trim().equals("")) {
            try {
                stream = this.getClass().getResourceAsStream(userFile);
                store = StyleStoreXMLReader.restoreFromStream(stream);
                this.addStore(store);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (FreeHEPLookup.instance().lookup(IStyleRegistry.class) == null) {
            FreeHEPLookup.instance().add(this);
        }
    }

    @Override
    public int getIndex() {
        int index = this.globalIndex++;
        return index;
    }

    @Override
    public void resetIndex() {
        this.globalIndex = 0;
    }

    IPlotterStyle mergeStyles(List styles, IPlotterState state) {
        if (styles == null || styles.size() == 0) {
            return null;
        }
        if (this.pf == null) {
            this.pf = new PlotterFactory();
        }
        PlotterStyle style = (PlotterStyle)this.pf.createPlotterStyle();
        style.setParameter("plotterStyleName", "StyleRegistry");
        style.setParentList(styles);
        return style;
    }

    public void addStore(IStyleStore store) {
        if (this.stores.contains(store)) {
            throw new IllegalArgumentException("StyleRegistry already contains store: " + store.getStoreName());
        }
        this.stores.add(store);
        this.addCategoriesFromStore(store);
    }

    public void removeStore(IStyleStore store) {
        if (!this.stores.contains(store)) {
            throw new IllegalArgumentException("StyleRegistry does not contains store: " + store.getStoreName());
        }
        this.stores.remove(store);
        this.removeCategoriesFromStore(store);
    }

    void updateCategories() {
        for (int i = 0; i < this.stores.size(); ++i) {
            this.addCategoriesFromStore((IStyleStore)this.stores.get(i));
        }
    }

    void addCategoriesFromStore(IStyleStore store) {
        String[] names = store.getAllStyleNames();
        if (names == null) {
            return;
        }
        HashMap hash = new HashMap();
        for (int i = 0; i < names.length; ++i) {
            String rule = store.getRuleForStyle(names[i]).getDescription();
            int index = rule.indexOf("attribute(");
            while (index >= 0) {
                ArrayList<String> list;
                rule = rule.substring(index + 11);
                index = rule.indexOf("attribute(");
                String token = null;
                token = index > 0 ? rule.substring(0, index) : rule;
                int index3 = token.indexOf("\").");
                String key = token.substring(0, index3);
                String value = token.substring(index3 + 1);
                value = value.substring(value.indexOf("\"") + 1);
                value = value.substring(0, value.indexOf("\""));
                if (key == null || key.trim().equals("")) continue;
                Object obj = hash.get(key);
                if (obj == null) {
                    list = new ArrayList<String>();
                    list.add(value);
                    hash.put(key, list);
                    continue;
                }
                list = (ArrayList<String>)obj;
                if (list.contains(value)) continue;
                list.add(value);
            }
        }
        if (hash.isEmpty()) {
            return;
        }
        for (String key : hash.keySet()) {
            ArrayList list = (ArrayList)hash.get(key);
            if (list.isEmpty()) continue;
            Object tmpCat = this.categories.get(key);
            Category cat = null;
            cat = tmpCat == null ? new Category(key) : (Category)tmpCat;
            for (int i = 0; i < list.size(); ++i) {
                Object tmp = list.get(i);
                if (tmp == null || ((String)tmp).equals("")) continue;
                cat.addValue((String)tmp);
            }
            this.categories.put(key, cat);
        }
        hash.clear();
    }

    void removeCategoriesFromStore(IStyleStore store) {
    }

    @Override
    public String[] getAvailableStoreNames() {
        String[] names = new String[this.stores.size()];
        for (int i = 0; i < this.stores.size(); ++i) {
            names[i] = ((IStyleStore)this.stores.get(i)).getStoreName();
        }
        return names;
    }

    @Override
    public IStyleStore getStore(String storeName) {
        IStyleStore store = null;
        String name = null;
        for (int i = 0; i < this.stores.size(); ++i) {
            name = ((IStyleStore)this.stores.get(i)).getStoreName();
            if (!storeName.equals(name)) continue;
            store = (IStyleStore)this.stores.get(i);
            break;
        }
        return store;
    }

    @Override
    public String[] getAvailableCategoryKeys() {
        this.updateCategories();
        String[] catKeys = new String[this.categories.size()];
        catKeys = this.categories.keySet().toArray(catKeys);
        return catKeys;
    }

    @Override
    public String[] getAvailableCategoryValues(String categoryKey) {
        return ((Category)this.categories.get(categoryKey)).getValues();
    }

    @Override
    public String getCategoryCurrentValue(String categoryKey) {
        return ((Category)this.categories.get(categoryKey)).getCurrentValue();
    }

    @Override
    public void setCategoryCurrentValue(String categoryKey, String categoryValue) {
        ((Category)this.categories.get(categoryKey)).setCurrentValue(categoryValue);
    }

    @Override
    public IPlotterStyle getStyleForState(IPlotterState state) {
        IPlotterStyle style = null;
        Vector<IPlotterStyle> styles = new Vector<IPlotterStyle>();
        int size = this.stores.size() - 1;
        for (int i = 0; i < this.stores.size(); ++i) {
            IStyleStore store = (IStyleStore)this.stores.get(size - i);
            String[] names = store.getAllStyleNames();
            for (int j = 0; j < names.length; ++j) {
                IStyleRule rule = store.getRuleForStyle(names[j]);
                if (!rule.ruleApplies(state) || styles.contains(style = store.getStyle(names[j]))) continue;
                styles.add(style);
            }
        }
        style = this.mergeStyles(styles, state);
        return style;
    }

    public static void main(String[] args) {
    }

    class Category {
        private String name;
        private String currentValue;
        private List values;

        Category(String name) {
            this.name = name;
            this.values = new ArrayList(10);
        }

        String getName() {
            return this.name;
        }

        void addValue(String v) {
            if (!this.values.contains(v)) {
                this.values.add(v);
            }
        }

        String getCurrentValue() {
            return this.currentValue;
        }

        void setCurrentValue(String v) {
            this.addValue(v);
            this.currentValue = v;
        }

        String[] getValues() {
            String[] valArr = new String[this.values.size()];
            valArr = this.values.toArray(valArr);
            return valArr;
        }

        void removeValue(String v) {
            if (this.values.contains(v)) {
                this.values.remove(v);
                if (this.currentValue != null && this.currentValue.equals(v)) {
                    this.currentValue = null;
                }
            }
        }
    }
}

