/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitFactory;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotter;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Gaussian;
import hep.aida.ref.pdf.PdfFitter;
import java.util.Random;

public class SimpleUnbinnedGaussianFit {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        ICloud1D c1 = histogramFactory.createCloud1D("Cloud 1D");
        Random r = new Random(123L);
        for (int i = 0; i < 100000; ++i) {
            c1.fill(r.nextGaussian());
        }
        IHistogram1D h1 = histogramFactory.createHistogram1D("Histogram 1D", 50, c1.lowerEdge(), c1.upperEdge());
        c1.fillHistogram(h1);
        Gaussian g = new Gaussian("myGauss");
        g.setParameter("mean", h1.mean() + 1.0);
        g.setParameter("sigma", h1.rms() + 2.0);
        IRangeSet r1 = g.normalizationRange(0);
        r1.excludeAll();
        r1.include(c1.lowerEdge(), c1.upperEdge());
        double h1Norm = h1.sumBinHeights() * (h1.axis().upperEdge() - h1.axis().lowerEdge()) / (double)h1.axis().bins();
        h1.scale(1.0 / h1Norm);
        plotter.region(0).plot((IBaseHistogram)h1);
        PdfFitter gaussFit = new PdfFitter("uml", "jminuit");
        gaussFit.setUseFunctionGradient(false);
        long start = System.currentTimeMillis();
        gaussFit.fit(c1, (Function)g);
        long end = System.currentTimeMillis();
        long time = end - start;
        System.out.println("Time to fit : " + time);
        plotter.region(0).plot((IFunction)g);
        plotter.show();
    }
}

