/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf.examples;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IFitFactory;
import hep.aida.IFitResult;
import hep.aida.IFitter;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IRangeSet;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.pdf.FunctionConverter;
import hep.aida.ref.pdf.Gaussian;
import java.util.Random;

public class NonParametricUnbinnedFit {
    public static void main(String[] args) {
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create();
        IHistogramFactory histogramFactory = analysisFactory.createHistogramFactory(tree);
        IFunctionFactory functionFactory = analysisFactory.createFunctionFactory(tree);
        IFitFactory fitFactory = analysisFactory.createFitFactory();
        IPlotter plotter = analysisFactory.createPlotterFactory().create("Plotter");
        ICloud1D c1 = histogramFactory.createCloud1D("Cloud 1D");
        Random r_1 = new Random(123L);
        Random r_2 = new Random(456L);
        for (int i = 0; i < 100000; ++i) {
            double x = r_1.nextGaussian();
            c1.fill(x);
        }
        Gaussian g = new Gaussian("myGauss");
        IModelFunction gauss = FunctionConverter.getIModelFunction(g);
        IRangeSet r1 = gauss.normalizationRange(0);
        r1.excludeAll();
        r1.include(c1.lowerEdge(), c1.upperEdge());
        gauss.setParameter("mean", c1.mean());
        gauss.setParameter("sigma", c1.rms());
        IFitter gaussFit = fitFactory.createFitter("chi2", "jminuit", "noClone=true");
        long start = System.currentTimeMillis();
        c1.convertToHistogram();
        IFitResult gaussFitResult = gaussFit.fit((IBaseHistogram)c1.histogram(), (IFunction)gauss);
        long end = System.currentTimeMillis();
        long time = end - start;
        System.out.println("Chi2 " + gaussFitResult.quality());
    }
}

