/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.uncmin;

import hep.aida.ref.optimizer.AbstractOptimizerConfiguration;

public class UncminOptimizerConfiguration
extends AbstractOptimizerConfiguration {
    public static final String LINE_SEARCH = "LIN";
    public static final String DOUBLE_DOGLEG = "DOU";
    public static final String MORE_HEBDON = "MOR";
    public static final int LOW_CALL_STRATEGY = 0;
    public static final int HIGH_CALL_STRATEGY = 1;
    public static final int LOW_CALL_STRATEGY_CHECK = 2;
    public static final int HIGH_CALL_STRATEGY_CHECK = 3;

    public UncminOptimizerConfiguration() {
        this.setTolerance(1.0E-5);
        this.setMaxIterations(50);
        this.setMethod(LINE_SEARCH);
        this.setStrategy(0);
    }

    @Override
    public void setMethod(String method) {
        if (!((method = method.toUpperCase()).startsWith(LINE_SEARCH) || method.startsWith(DOUBLE_DOGLEG) || method.startsWith(MORE_HEBDON))) {
            throw new IllegalArgumentException("Unsupported method : " + method);
        }
        super.setMethod(method);
    }

    @Override
    public void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                super.setStrategy(strategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported strategy : " + strategy);
            }
        }
    }

    @Override
    public void setPrecision(double precision) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setErrorDefinition(int errorDefinition) throws IllegalArgumentException {
    }

    @Override
    public int errorDefinition() {
        return Integer.MIN_VALUE;
    }
}

