/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.Binner2D;
import java.io.Serializable;

public class BasicBinner2D
implements Binner2D,
Serializable {
    private int[][] entries;
    private double[][] heights;
    private double[][] plusErrors;
    private double[][] meansX;
    private double[][] rmssX;
    private double[][] meansY;
    private double[][] rmssY;
    private int xBins;
    private int yBins;

    public BasicBinner2D(int xBins, int yBins) {
        if (xBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + xBins);
        }
        if (yBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + yBins);
        }
        this.setNumberOfBins(xBins, yBins);
    }

    @Override
    public void fill(int xBin, int yBin, double x, double y, double weight) {
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin];
        int n2 = yBin;
        dArray[n2] = dArray[n2] + weight;
        double[] dArray2 = this.plusErrors[xBin];
        int n3 = yBin;
        dArray2[n3] = dArray2[n3] + weight * weight;
        double[] dArray3 = this.meansX[xBin];
        int n4 = yBin;
        dArray3[n4] = dArray3[n4] + x * weight;
        double[] dArray4 = this.rmssX[xBin];
        int n5 = yBin;
        dArray4[n5] = dArray4[n5] + x * x * weight;
        double[] dArray5 = this.meansY[xBin];
        int n6 = yBin;
        dArray5[n6] = dArray5[n6] + y * weight;
        double[] dArray6 = this.rmssY[xBin];
        int n7 = yBin;
        dArray6[n7] = dArray6[n7] + y * y * weight;
    }

    @Override
    public void clear() {
        this.createArrays(this.xBins, this.yBins);
    }

    private void setNumberOfBins(int xBins, int yBins) {
        this.xBins = xBins;
        this.yBins = yBins;
        this.createArrays(xBins, yBins);
    }

    @Override
    public int entries(int xBin, int yBin) {
        return this.entries[xBin][yBin];
    }

    @Override
    public double height(int xBin, int yBin) {
        return this.heights[xBin][yBin];
    }

    @Override
    public double plusError(int xBin, int yBin) {
        return Math.sqrt(this.plusErrors[xBin][yBin]);
    }

    @Override
    public double minusError(int xBin, int yBin) {
        return this.plusError(xBin, yBin);
    }

    @Override
    public double meanX(int xBin, int yBin) {
        double h = this.height(xBin, yBin);
        if (h != 0.0) {
            return this.meansX[xBin][yBin] / h;
        }
        return Double.NaN;
    }

    @Override
    public double meanY(int xBin, int yBin) {
        double h = this.height(xBin, yBin);
        if (h != 0.0) {
            return this.meansY[xBin][yBin] / h;
        }
        return Double.NaN;
    }

    @Override
    public double rmsX(int xBin, int yBin) {
        double h = this.height(xBin, yBin);
        double m = this.meanX(xBin, yBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssX[xBin][yBin] / h - m * m));
        }
        return Double.NaN;
    }

    @Override
    public double rmsY(int xBin, int yBin) {
        double h = this.height(xBin, yBin);
        double m = this.meanY(xBin, yBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssY[xBin][yBin] / h - m * m));
        }
        return Double.NaN;
    }

    @Override
    public void setBinContent(int xBin, int yBin, int entries, double height, double plusError, double minusError, double meanX, double rmsX, double meanY, double rmsY) {
        this.entries[xBin][yBin] = entries;
        this.heights[xBin][yBin] = !Double.isNaN(height) ? height : (double)entries;
        this.plusErrors[xBin][yBin] = !Double.isNaN(plusError) ? plusError * plusError : (double)entries;
        this.meansX[xBin][yBin] = 0.0;
        this.rmssX[xBin][yBin] = 0.0;
        this.meansY[xBin][yBin] = 0.0;
        this.rmssY[xBin][yBin] = 0.0;
        if (height != 0.0) {
            this.meansX[xBin][yBin] = meanX * height;
            this.rmssX[xBin][yBin] = rmsX * rmsX * height + meanX * meanX * height;
            this.meansY[xBin][yBin] = meanY * height;
            this.rmssY[xBin][yBin] = rmsY * rmsY * height + meanY * meanY * height;
        }
    }

    @Override
    public void scale(double scaleFactor) {
        for (int xBin = 0; xBin < this.xBins; ++xBin) {
            int yBin = 0;
            while (yBin < this.yBins) {
                double[] dArray = this.heights[xBin];
                int n = yBin;
                dArray[n] = dArray[n] * scaleFactor;
                double[] dArray2 = this.plusErrors[xBin];
                int n2 = yBin;
                dArray2[n2] = dArray2[n2] * (scaleFactor * scaleFactor);
                double[] dArray3 = this.meansX[xBin];
                int n3 = yBin;
                dArray3[n3] = dArray3[n3] * scaleFactor;
                double[] dArray4 = this.rmssX[xBin];
                int n4 = yBin;
                dArray4[n4] = dArray4[n4] * scaleFactor;
                double[] dArray5 = this.meansY[xBin];
                int n5 = yBin;
                dArray5[n5] = dArray5[n5] * scaleFactor;
                double[] dArray6 = this.rmssY[xBin];
                int n6 = yBin++;
                dArray6[n6] = dArray6[n6] * scaleFactor;
            }
        }
    }

    private void createArrays(int xBins, int yBins) {
        this.entries = new int[xBins][yBins];
        this.heights = new double[xBins][yBins];
        this.plusErrors = new double[xBins][yBins];
        this.meansX = new double[xBins][yBins];
        this.rmssX = new double[xBins][yBins];
        this.meansY = new double[xBins][yBins];
        this.rmssY = new double[xBins][yBins];
    }
}

