/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IProfile2D;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.Profile;
import java.io.Serializable;

public class Profile2D
extends Profile
implements IProfile2D,
IsObservable,
Serializable {
    private Histogram3D hist;

    public Profile2D() {
        super("", "", 2);
    }

    public Profile2D(String name, String title, IAxis xAxis, IAxis yAxis) {
        this(name, title, xAxis, yAxis, "");
    }

    public Profile2D(String name, String title, IAxis xAxis, IAxis yAxis, String options) {
        super(name, title, 2, options);
        this.initProfile2D(xAxis, yAxis, options);
    }

    @Override
    public void reset() {
        this.hist.reset();
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double binMeanX(int indexX, int indexY) {
        return this.hist.binMeanX(indexX, indexY, 0);
    }

    public double binMeanY(int indexX, int indexY) {
        return this.hist.binMeanY(indexX, indexY, 0);
    }

    public int binEntries(int indexX, int indexY) {
        return this.hist.binEntries(indexX, indexY, 0);
    }

    public int binEntriesX(int indexX) {
        return this.hist.binEntriesX(indexX);
    }

    public int binEntriesY(int indexY) {
        return this.hist.binEntriesY(indexY);
    }

    public double binError(int indexX, int indexY) {
        if (this.binEntries(indexX, indexY) == 0) {
            return 0.0;
        }
        double sOfWeights = this.hist.binHeight(indexX, indexY, 0);
        if (sOfWeights != 0.0) {
            return Math.abs(this.hist.binMeanZ(indexX, indexY, 0) / sOfWeights);
        }
        return 0.0;
    }

    public double binHeight(int indexX, int indexY) {
        if (this.binEntries(indexX, indexY) == 0) {
            return 0.0;
        }
        return this.hist.binMeanZ(indexX, indexY, 0);
    }

    public double binHeightX(int indexX) {
        return this.hist.binHeightX(indexX);
    }

    public double binHeightY(int indexY) {
        return this.hist.binHeightY(indexY);
    }

    public double binRms(int indexX, int indexY) {
        if (this.binEntries(indexX, indexY) == 0) {
            return 0.0;
        }
        return this.hist.binRmsZ(indexX, indexY, 0);
    }

    public int coordToIndexX(double coord) {
        return this.hist.xAxis().coordToIndex(coord);
    }

    public int coordToIndexY(double coord) {
        return this.hist.yAxis().coordToIndex(coord);
    }

    public void fill(double x, double y, double z) throws IllegalArgumentException {
        this.hist.fill(x, y, z);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void fill(double x, double y, double z, double weight) throws IllegalArgumentException {
        this.hist.fill(x, y, z, weight);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double meanX() {
        return this.hist.meanX();
    }

    public double meanY() {
        return this.hist.meanY();
    }

    public double rmsX() {
        return this.hist.rmsX();
    }

    public double rmsY() {
        return this.hist.rmsY();
    }

    public IAxis xAxis() {
        return this.hist.xAxis();
    }

    public IAxis yAxis() {
        return this.hist.yAxis();
    }

    @Override
    public int entries() {
        return this.hist.entries();
    }

    public int allEntries() {
        return this.hist.allEntries();
    }

    public int extraEntries() {
        int n = 0;
        int i = this.xAxis().bins();
        while (--i >= -2) {
            int j = this.yAxis().bins();
            while (--j >= -2) {
                if (i >= 0 && j >= 0) continue;
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    public double maxBinHeight() {
        double max = Double.NaN;
        for (int i = 1; i <= this.xAxis().bins(); ++i) {
            for (int j = 1; j <= this.yAxis().bins(); ++j) {
                if (!Double.isNaN(max) && !(this.binHeight(i, j) >= max)) continue;
                max = this.binHeight(i, j);
            }
        }
        return max;
    }

    public double minBinHeight() {
        double min = Double.NaN;
        for (int i = 1; i <= this.xAxis().bins(); ++i) {
            for (int j = 1; j <= this.yAxis().bins(); ++j) {
                if (!Double.isNaN(min) && !(this.binHeight(i, j) <= min)) continue;
                min = this.binHeight(i, j);
            }
        }
        return min;
    }

    public double sumAllBinHeights() {
        double sum = 0.0;
        int i = this.xAxis().bins();
        while (--i >= -2) {
            int j = this.yAxis().bins();
            while (--j >= -2) {
                sum += this.binHeight(i, j);
            }
        }
        return sum;
    }

    public double sumBinHeights() {
        return this.sumAllBinHeights() - this.sumExtraBinHeights();
    }

    public double sumExtraBinHeights() {
        int sum = 0;
        int i = this.xAxis().bins();
        while (--i >= -2) {
            int j = this.yAxis().bins();
            while (--j >= -2) {
                if (i >= 0 && j >= 0) continue;
                sum = (int)((double)sum + this.binHeight(i, j));
            }
        }
        return sum;
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        this.hist.scale(scaleFactor);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void add(IProfile2D profile) throws IllegalArgumentException {
        this.hist.add(((Profile2D)profile).histogram());
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    protected Histogram3D histogram() {
        return this.hist;
    }

    protected void setHistogram(Histogram3D hist) {
        this.hist = hist;
    }

    public void initProfile2D(IAxis xAxis, IAxis yAxis) {
        this.initProfile2D(xAxis, yAxis, "");
    }

    public void initProfile2D(IAxis xAxis, IAxis yAxis, String options) {
        FixedAxis zAxis = new FixedAxis(1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.hist = new Histogram3D(this.name(), this.title(), xAxis, yAxis, zAxis, options);
        this.reset();
    }

    public void setRmsX(double rmsX) {
        this.hist.setRmsX(rmsX);
    }

    public void setRmsY(double rmsY) {
        this.hist.setRmsY(rmsY);
    }

    public void setMeanX(double meanX) {
        this.hist.setMeanX(meanX);
    }

    public void setMeanY(double meanY) {
        this.hist.setMeanY(meanY);
    }

    public void setNEntries(int entries) {
        this.hist.setNEntries(entries);
    }

    public void setValidEntries(int entries) {
        this.hist.setValidEntries(entries);
    }

    public void setContents(double[][] heights, double[][] errors, int[][] entries, double[][] rmss, double[][] meanXs, double[][] meanYs) {
        int binX = this.xAxis().bins() + 2;
        int binY = this.yAxis().bins() + 2;
        int[][][] n = new int[binX][binY][3];
        double[][][] h = new double[binX][binY][3];
        double[][][] e = new double[binX][binY][3];
        double[][][] mx = new double[binX][binY][3];
        double[][][] rx = new double[binX][binY][3];
        double[][][] my = new double[binX][binY][3];
        double[][][] ry = new double[binX][binY][3];
        double[][][] mz = new double[binX][binY][3];
        double[][][] rz = new double[binX][binY][3];
        for (int i = 0; i < binX; ++i) {
            for (int j = 0; j < binY; ++j) {
                if (errors[i][j] != 0.0) {
                    h[i][j][1] = Math.abs(heights[i][j] / errors[i][j]);
                }
                e[i][j][1] = errors[i][j];
                n[i][j][1] = entries[i][j];
                mx[i][j][1] = meanXs[i][j];
                my[i][j][1] = meanYs[i][j];
                mz[i][j][1] = heights[i][j];
                rz[i][j][1] = Math.abs(rmss[i][j]);
            }
        }
        this.hist.setContents(h, e, n, mx, rx, my, ry, mz, rz);
    }
}

