/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IProfile1D;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Profile;
import java.io.Serializable;

public class Profile1D
extends Profile
implements IProfile1D,
Serializable,
IsObservable {
    private Histogram2D hist;

    public Profile1D() {
        super("", "", 1);
    }

    public Profile1D(String name, String title, IAxis axis) {
        this(name, title, axis, "");
    }

    public Profile1D(String name, String title, IAxis axis, String options) {
        super(name, title, 1, options);
        this.initProfile1D(axis, options);
    }

    @Override
    public void reset() {
        this.hist.reset();
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    @Override
    public int entries() {
        return this.hist.entries();
    }

    public int allEntries() {
        return this.hist.allEntries();
    }

    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    public double sumAllBinHeights() {
        double sum = 0.0;
        int i = this.axis().bins();
        while (--i >= -2) {
            sum += this.binHeight(i);
        }
        return sum;
    }

    public double sumBinHeights() {
        return this.sumAllBinHeights() - this.sumExtraBinHeights();
    }

    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    public double minBinHeight() {
        double min = Double.NaN;
        for (int i = 1; i <= this.axis().bins(); ++i) {
            if (!Double.isNaN(min) && !(this.binHeight(i) <= min)) continue;
            min = this.binHeight(i);
        }
        return min;
    }

    public double maxBinHeight() {
        double max = Double.NaN;
        for (int i = 1; i <= this.axis().bins(); ++i) {
            if (!Double.isNaN(max) && !(this.binHeight(i) >= max)) continue;
            max = this.binHeight(i);
        }
        return max;
    }

    public void fill(double x, double y, double weight) {
        this.hist.fill(x, y, weight);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void fill(double x, double y) {
        this.fill(x, y, 1.0);
    }

    public int binEntries(int index) {
        return this.hist.binEntries(index, 0);
    }

    public double binHeight(int index) {
        if (this.binEntries(index) == 0) {
            return 0.0;
        }
        return this.hist.binMeanY(index, 0);
    }

    public double binError(int index) {
        if (this.binEntries(index) == 0) {
            return 0.0;
        }
        double sOfWeights = this.hist.binHeight(index, 0);
        if (sOfWeights != 0.0) {
            return Math.abs(this.hist.binMeanY(index, 0) / sOfWeights);
        }
        return 0.0;
    }

    public double binMean(int index) {
        return this.hist.binMeanX(index, 0);
    }

    public double binRms(int index) {
        if (this.binEntries(index) == 0) {
            return 0.0;
        }
        return this.hist.binRmsY(index, 0);
    }

    public double mean() {
        return this.hist.meanX();
    }

    public double rms() {
        return this.hist.rmsX();
    }

    public IAxis axis() {
        return this.hist.xAxis();
    }

    public int coordToIndex(double coord) {
        return this.axis().coordToIndex(coord);
    }

    public void scale(double scaleFactor) throws IllegalArgumentException {
        this.hist.scale(scaleFactor);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void add(IProfile1D profile) throws IllegalArgumentException {
        this.hist.add(((Profile1D)profile).histogram());
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    protected Histogram2D histogram() {
        return this.hist;
    }

    protected void setHistogram(Histogram2D hist) {
        this.hist = hist;
    }

    public void initProfile1D(IAxis axis) {
        this.initProfile1D(axis, "");
    }

    public void initProfile1D(IAxis axis, String options) {
        FixedAxis yAxis = new FixedAxis(1, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.hist = new Histogram2D(this.name(), this.title(), axis, yAxis, options);
        this.reset();
    }

    public void setRms(double rms) {
        this.hist.setRmsX(rms);
    }

    public void setMean(double mean) {
        this.hist.setMeanX(mean);
    }

    public void setContents(double[] heights, double[] errors, int[] entries, double[] rmss, double[] meanXs) {
        int binX = this.axis().bins() + 2;
        int[][] n = new int[binX][3];
        double[][] h = new double[binX][3];
        double[][] e = new double[binX][3];
        double[][] mx = new double[binX][3];
        double[][] rx = new double[binX][3];
        double[][] my = new double[binX][3];
        double[][] ry = new double[binX][3];
        for (int i = 0; i < binX; ++i) {
            if (errors[i] != 0.0) {
                h[i][1] = Math.abs(heights[i] / errors[i]);
            }
            e[i][1] = errors[i];
            n[i][1] = entries[i];
            if (meanXs != null) {
                mx[i][1] = meanXs[i];
            }
            my[i][1] = heights[i];
            if (rmss == null) continue;
            ry[i][1] = Math.abs(rmss[i]);
        }
        this.hist.setContents(h, e, n, mx, rx, my, ry);
    }

    public void setNEntries(int entries) {
        this.hist.setNEntries(entries);
    }

    public void setValidEntries(int entries) {
        this.hist.setValidEntries(entries);
    }
}

