/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.ICloud1D;
import hep.aida.IHistogram;
import hep.aida.IHistogram1D;
import hep.aida.ref.histogram.Cloud;
import hep.aida.ref.histogram.HistUtils;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.VariableAxis;
import java.util.ArrayList;

public class Cloud1D
extends Cloud
implements ICloud1D {
    private int nEntries = 0;
    private double lowerEdge = Double.NaN;
    private double upperEdge = Double.NaN;
    protected double sumOfWeights;
    private double mean;
    private double rms;
    private IHistogram1D histo;
    private ArrayList valuesArray = new ArrayList();
    private ArrayList weightsArray = new ArrayList();
    private double[] values;
    private double[] weights;
    private int convBins = 50;
    private double convLowerEdge = Double.NaN;
    private double convUpperEdge = Double.NaN;

    public Cloud1D() {
        super("", "", 1, 0, "");
    }

    protected Cloud1D(String name, String title, int nMax, String options) {
        super(name, title, 1, nMax, options);
    }

    public void fill(double value) {
        this.fill(value, 1.0);
    }

    public void fill(double value, double weight) {
        if (this.nEntries == 0) {
            this.lowerEdge = this.upperEdge = value;
        } else {
            if (value < this.lowerEdge) {
                this.lowerEdge = value;
            }
            if (value > this.upperEdge) {
                this.upperEdge = value;
            }
        }
        if (this.histo != null) {
            this.histo.fill(value, weight);
        } else if (this.autoConvert() && this.nEntries == this.maxEntries) {
            if (this.histo != null) {
                throw new RuntimeException("Cloud already been converted");
            }
            this.histo = this.toShowableHistogram(this.conversionBins(), this.conversionLowerEdge(), this.conversionUpperEdge());
            this.histo.fill(value, weight);
            this.values = null;
            this.weights = null;
            this.valuesArray.clear();
            this.weightsArray.clear();
            this.valuesArray = null;
            this.weightsArray = null;
        } else {
            if (this.nEntries % this.arraySize == 0) {
                this.values = new double[this.arraySize];
                this.weights = new double[this.arraySize];
                this.valuesArray.add(this.values);
                this.weightsArray.add(this.weights);
            }
            this.values[this.nEntries % this.arraySize] = value;
            this.weights[this.nEntries % this.arraySize] = weight;
            if (!Double.isNaN(value) && !Double.isNaN(weight)) {
                this.sumOfWeights += weight;
                this.mean += value * weight;
                this.rms += value * value * weight;
                ++this.validEntries;
            }
            ++this.nEntries;
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public double lowerEdge() {
        return this.lowerEdge;
    }

    public double upperEdge() {
        return this.upperEdge;
    }

    public void setUpperEdge(double upperEdge) {
        this.upperEdge = upperEdge;
    }

    public void setLowerEdge(double lowerEdge) {
        this.lowerEdge = lowerEdge;
    }

    public double value(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.valuesArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double weight(int index) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud has been converted");
        }
        double[] val = (double[])this.weightsArray.get(index / this.arraySize);
        return val[index % this.arraySize];
    }

    public double mean() {
        if (this.histo != null) {
            return this.histo.mean();
        }
        return this.mean / this.sumOfWeights();
    }

    public double rms() {
        if (this.histo != null) {
            return this.histo.rms();
        }
        return Math.sqrt(this.rms / this.sumOfWeights() - this.mean * this.mean / this.sumOfWeights() / this.sumOfWeights());
    }

    @Override
    public int entries() {
        if (this.histo != null) {
            return this.histo.allEntries();
        }
        return this.nEntries;
    }

    private IHistogram1D toShowableHistogram(int nBins, double lowerEdge, double upperEdge) {
        if (this.histo != null) {
            return this.histo;
        }
        return HistUtils.toShowableHistogram(this, nBins, lowerEdge, upperEdge);
    }

    public void convert(int nBins, double lowerEdge, double upperEdge) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        this.histo = this.toShowableHistogram(nBins, lowerEdge, upperEdge);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void convert(double[] binEdges) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        Histogram1D hist = new Histogram1D(this.name(), this.title(), new VariableAxis(binEdges));
        for (int i = 0; i < this.nEntries; ++i) {
            hist.fill(this.value(i), this.weight(i));
        }
        this.histo = hist;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    @Override
    public boolean isConverted() {
        return this.histo != null;
    }

    public IHistogram1D histogram() throws RuntimeException {
        if (this.histo == null) {
            throw new RuntimeException("Cloud has not been converted");
        }
        return this.histo;
    }

    public void setHistogram(IHistogram1D hist) {
        if (this.histo != null) {
            throw new RuntimeException("Cloud already been converted");
        }
        this.histo = hist;
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public void fillHistogram(IHistogram1D hist1d) {
        if (this.histo != null) {
            throw new IllegalArgumentException("Cloud has already been converted");
        }
        for (int i = 0; i < this.nEntries; ++i) {
            hist1d.fill(this.value(i), this.weight(i));
        }
    }

    @Override
    public void reset() {
        this.nEntries = 0;
        this.lowerEdge = Double.NaN;
        this.upperEdge = Double.NaN;
        this.mean = 0.0;
        this.rms = 0.0;
        this.sumOfWeights = 0.0;
        if (this.histo != null) {
            this.histo.reset();
        }
        this.histo = null;
        this.valuesArray = new ArrayList();
        this.weightsArray = new ArrayList();
        this.values = null;
        this.weights = null;
        super.reset();
    }

    @Override
    public void convertToHistogram() {
        if (this.histo != null) {
            throw new IllegalArgumentException("Cloud has already been converted to an Histogram");
        }
        this.histo = this.toShowableHistogram(this.conversionBins(), this.conversionLowerEdge(), this.conversionUpperEdge());
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    @Override
    public void scale(double scaleFactor) throws IllegalArgumentException {
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Illegal scale factor " + scaleFactor + " it has to be positive");
        }
        if (this.isConverted()) {
            this.histo.scale(scaleFactor);
        } else {
            for (int i = 0; i < this.entries(); ++i) {
                double[] weights = (double[])this.weightsArray.get(i / this.arraySize);
                int n = i % this.arraySize;
                weights[n] = weights[n] * scaleFactor;
            }
            this.sumOfWeights *= scaleFactor;
            this.mean *= scaleFactor;
            this.rms *= scaleFactor;
        }
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    @Override
    public double sumOfWeights() {
        if (this.histo != null) {
            return this.histo.sumAllBinHeights();
        }
        return this.sumOfWeights;
    }

    public double lowerEdgeWithMargin() {
        if (Double.isNaN(this.lowerEdge)) {
            return Double.NaN;
        }
        double le = this.lowerEdge != this.upperEdge ? this.lowerEdge : this.lowerEdge - 1.0;
        double ue = this.lowerEdge != this.upperEdge ? this.upperEdge : this.upperEdge + 1.0;
        double delta = ue - le;
        return le - this.margin() * Math.abs(delta);
    }

    public double upperEdgeWithMargin() {
        if (Double.isNaN(this.upperEdge)) {
            return Double.NaN;
        }
        double le = this.lowerEdge != this.upperEdge ? this.lowerEdge : this.lowerEdge - 1.0;
        double ue = this.lowerEdge != this.upperEdge ? this.upperEdge : this.upperEdge + 1.0;
        double delta = ue - le;
        return ue + this.margin() * Math.abs(delta);
    }

    @Override
    protected IHistogram hist() {
        return this.histogram();
    }

    public void setConversionParameters(int bins, double lowerEdge, double upperEdge) {
        this.convBins = bins;
        this.convLowerEdge = lowerEdge;
        this.convUpperEdge = upperEdge;
    }

    public int conversionBins() {
        return this.convBins;
    }

    public double conversionLowerEdge() {
        if (Double.isNaN(this.convLowerEdge)) {
            return this.lowerEdgeWithMargin();
        }
        return this.convLowerEdge;
    }

    public double conversionUpperEdge() {
        if (Double.isNaN(this.convUpperEdge)) {
            return this.upperEdgeWithMargin();
        }
        return this.convUpperEdge;
    }
}

