/*
 * Decompiled with CFR 0.152.
 */
package recunn.util;

import java.util.ArrayList;
import java.util.Random;
import recunn.model.FeedForwardLayer;
import recunn.model.GruLayer;
import recunn.model.LinearLayer;
import recunn.model.LstmLayer;
import recunn.model.Model;
import recunn.model.NeuralNetwork;
import recunn.model.Nonlinearity;
import recunn.model.RnnLayer;

public class NeuralNetworkHelper {
    public static NeuralNetwork makeLstm(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        for (int h = 0; h < hiddenLayers; ++h) {
            if (h == 0) {
                layers.add(new LstmLayer(inputDimension, hiddenDimension, initParamsStdDev, rng));
                continue;
            }
            layers.add(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeLstmWithInputBottleneck(int inputDimension, int bottleneckDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        layers.add(new LinearLayer(inputDimension, bottleneckDimension, initParamsStdDev, rng));
        for (int h = 0; h < hiddenLayers; ++h) {
            if (h == 0) {
                layers.add(new LstmLayer(bottleneckDimension, hiddenDimension, initParamsStdDev, rng));
                continue;
            }
            layers.add(new LstmLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeFeedForward(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity hiddenUnit, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        if (hiddenLayers == 0) {
            layers.add(new FeedForwardLayer(inputDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
            return new NeuralNetwork(layers);
        }
        for (int h = 0; h < hiddenLayers; ++h) {
            if (h == 0) {
                layers.add(new FeedForwardLayer(inputDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
                continue;
            }
            layers.add(new FeedForwardLayer(hiddenDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeGru(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        for (int h = 0; h < hiddenLayers; ++h) {
            if (h == 0) {
                layers.add(new GruLayer(inputDimension, hiddenDimension, initParamsStdDev, rng));
                continue;
            }
            layers.add(new GruLayer(hiddenDimension, hiddenDimension, initParamsStdDev, rng));
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }

    public static NeuralNetwork makeRnn(int inputDimension, int hiddenDimension, int hiddenLayers, int outputDimension, Nonlinearity hiddenUnit, Nonlinearity decoderUnit, double initParamsStdDev, Random rng) {
        ArrayList<Model> layers = new ArrayList<Model>();
        for (int h = 0; h < hiddenLayers; ++h) {
            if (h == 0) {
                layers.add(new RnnLayer(inputDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
                continue;
            }
            layers.add(new RnnLayer(hiddenDimension, hiddenDimension, hiddenUnit, initParamsStdDev, rng));
        }
        layers.add(new FeedForwardLayer(hiddenDimension, outputDimension, decoderUnit, initParamsStdDev, rng));
        return new NeuralNetwork(layers);
    }
}

