/*
 * Decompiled with CFR 0.152.
 */
package recunn.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import recunn.autodiff.Graph;
import recunn.matrix.Matrix;
import recunn.model.Model;
import recunn.model.Nonlinearity;

public class RnnLayer
implements Model {
    private static final long serialVersionUID = 1L;
    int inputDimension;
    int outputDimension;
    Matrix W;
    Matrix b;
    Matrix context;
    Nonlinearity f;

    public RnnLayer(int inputDimension, int outputDimension, Nonlinearity hiddenUnit, double initParamsStdDev, Random rng) {
        this.inputDimension = inputDimension;
        this.outputDimension = outputDimension;
        this.f = hiddenUnit;
        this.W = Matrix.rand(outputDimension, inputDimension + outputDimension, initParamsStdDev, rng);
        this.b = new Matrix(outputDimension);
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix output;
        Matrix concat = g.concatVectors(input, this.context);
        Matrix sum = g.mul(this.W, concat);
        sum = g.add(sum, this.b);
        this.context = output = g.nonlin(this.f, sum);
        return output;
    }

    @Override
    public void resetState() {
        this.context = new Matrix(this.outputDimension);
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        result.add(this.W);
        result.add(this.b);
        return result;
    }
}

