/*
 * Decompiled with CFR 0.152.
 */
package recunn.model;

import java.util.ArrayList;
import java.util.List;
import recunn.autodiff.Graph;
import recunn.matrix.Matrix;
import recunn.model.Model;

public class NeuralNetwork
implements Model {
    private static final long serialVersionUID = 1L;
    List<Model> layers = new ArrayList<Model>();

    public NeuralNetwork(List<Model> layers) {
        this.layers = layers;
    }

    @Override
    public Matrix forward(Matrix input, Graph g) throws Exception {
        Matrix prev = input;
        for (Model layer : this.layers) {
            prev = layer.forward(prev, g);
        }
        return prev;
    }

    @Override
    public void resetState() {
        for (Model layer : this.layers) {
            layer.resetState();
        }
    }

    @Override
    public List<Matrix> getParameters() {
        ArrayList<Matrix> result = new ArrayList<Matrix>();
        for (Model layer : this.layers) {
            result.addAll(layer.getParameters());
        }
        return result;
    }
}

