/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.quantile.Buffer;

class DoubleBuffer
extends Buffer {
    protected DoubleArrayList values = new DoubleArrayList(0);
    protected boolean isSorted = false;

    public DoubleBuffer(int n) {
        super(n);
    }

    public void add(double d) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.add(d);
        this.isSorted = false;
    }

    public void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        if (!this.isAllocated) {
            this.allocate();
        }
        this.values.addAllOfFromTo(doubleArrayList, n, n2);
        this.isSorted = false;
    }

    protected void allocate() {
        this.isAllocated = true;
        this.values.ensureCapacity(this.k);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Object clone() {
        DoubleBuffer doubleBuffer = (DoubleBuffer)super.clone();
        if (this.values != null) {
            doubleBuffer.values = doubleBuffer.values.copy();
        }
        return doubleBuffer;
    }

    public boolean contains(double d) {
        this.sort();
        return this.values.contains(d);
    }

    @Override
    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    @Override
    public boolean isFull() {
        return this.values.size() == this.k;
    }

    public int memory() {
        return this.values.elements().length;
    }

    public double rank(double d) {
        this.sort();
        return Descriptive.rankInterpolated(this.values, d);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void sort() {
        if (!this.isSorted) {
            this.values.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        return "k=" + this.k + ", w=" + Long.toString(this.weight()) + ", l=" + Integer.toString(this.level()) + ", size=" + this.values.size();
    }
}

