/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;

public class VonMises
extends AbstractContinousDistribution {
    protected double my_k;
    private double k_set = -1.0;
    private double tau;
    private double rho;
    private double r;
    protected static VonMises shared = new VonMises(1.0, VonMises.makeDefaultGenerator());

    public VonMises(double d, RandomEngine randomEngine) {
        this.setRandomGenerator(randomEngine);
        this.setState(d);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.my_k);
    }

    public double nextDouble(double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.k_set != d) {
            this.tau = 1.0 + Math.sqrt(1.0 + 4.0 * d * d);
            this.rho = (this.tau - Math.sqrt(2.0 * this.tau)) / (2.0 * d);
            this.r = (1.0 + this.rho * this.rho) / (2.0 * this.rho);
            this.k_set = d;
        }
        do {
            d3 = this.randomGenerator.raw();
            d2 = this.randomGenerator.raw();
        } while ((d6 = d * (this.r - (d5 = (1.0 + this.r * (d4 = Math.cos(Math.PI * d3))) / (this.r + d4)))) * (2.0 - d6) < d2 && Math.log(d6 / d2) + 1.0 < d6);
        return this.randomGenerator.raw() > 0.5 ? Math.acos(d5) : -Math.acos(d5);
    }

    public void setState(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.my_k = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d) {
        VonMises vonMises = shared;
        synchronized (vonMises) {
            return shared.nextDouble(d);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.my_k + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomEngine) {
        VonMises vonMises = shared;
        synchronized (vonMises) {
            shared.setRandomGenerator(randomEngine);
        }
    }
}

