/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.ref;

import cern.hep.aida.ref.AbstractHistogram2D;
import cern.hep.aida.ref.FixedAxis;
import cern.hep.aida.ref.Histogram1D;
import cern.hep.aida.ref.VariableAxis;
import colt.hep.aida.IAxis;
import colt.hep.aida.IHistogram1D;
import colt.hep.aida.IHistogram2D;

public class Histogram2D
extends AbstractHistogram2D
implements IHistogram2D {
    private double[][] heights;
    private double[][] errors;
    private int[][] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;

    public Histogram2D(String string, double[] dArray, double[] dArray2) {
        this(string, new VariableAxis(dArray), new VariableAxis(dArray2));
    }

    public Histogram2D(String string, int n, double d, double d2, int n2, double d3, double d4) {
        this(string, new FixedAxis(n, d, d2), new FixedAxis(n2, d3, d4));
    }

    public Histogram2D(String string, IAxis iAxis, IAxis iAxis2) {
        super(string);
        this.xAxis = iAxis;
        this.yAxis = iAxis2;
        int n = iAxis.bins();
        int n2 = iAxis2.bins();
        this.entries = new int[n + 2][n2 + 2];
        this.heights = new double[n + 2][n2 + 2];
        this.errors = new double[n + 2][n2 + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int n, int n2) {
        return this.entries[this.mapX(n)][this.mapY(n2)];
    }

    @Override
    public double binError(int n, int n2) {
        return Math.sqrt(this.errors[this.mapX(n)][this.mapY(n2)]);
    }

    @Override
    public double binHeight(int n, int n2) {
        return this.heights[this.mapX(n)][this.mapY(n2)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double d, double d2) {
        int n = this.mapX(this.xAxis.coordToIndex(d));
        int n2 = this.mapY(this.yAxis.coordToIndex(d2));
        int[] nArray = this.entries[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
        double[] dArray = this.heights[n];
        int n4 = n2;
        dArray[n4] = dArray[n4] + 1.0;
        double[] dArray2 = this.errors[n];
        int n5 = n2;
        dArray2[n5] = dArray2[n5] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.meanX += d;
        this.rmsX += d;
        this.meanY += d2;
        this.rmsY += d2;
    }

    @Override
    public void fill(double d, double d2, double d3) {
        int n = this.mapX(this.xAxis.coordToIndex(d));
        int n2 = this.mapY(this.yAxis.coordToIndex(d2));
        int[] nArray = this.entries[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
        double[] dArray = this.heights[n];
        int n4 = n2;
        dArray[n4] = dArray[n4] + d3;
        double[] dArray2 = this.errors[n];
        int n5 = n2;
        dArray2[n5] = dArray2[n5] + d3 * d3;
        ++this.nEntry;
        this.sumWeight += d3;
        this.sumWeightSquared += d3 * d3;
        this.meanX += d * d3;
        this.rmsX += d * d3 * d3;
        this.meanY += d2 * d3;
        this.rmsY += d2 * d3 * d3;
    }

    @Override
    protected IHistogram1D internalSliceX(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int[] nArray = new int[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = n; j <= n2; ++j) {
                int n4 = i;
                nArray[n4] = nArray[n4] + this.entries[i][j];
                int n5 = i;
                dArray[n5] = dArray[n5] + this.heights[i][j];
                int n6 = i;
                dArray2[n6] = dArray2[n6] + this.errors[i][j];
            }
        }
        Histogram1D histogram1D = new Histogram1D(string, this.xAxis);
        histogram1D.setContents(nArray, dArray, dArray2);
        return histogram1D;
    }

    @Override
    protected IHistogram1D internalSliceY(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.yAxis.bins() + 2;
        int[] nArray = new int[n3];
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = j;
                nArray[n4] = nArray[n4] + this.entries[i][j];
                int n5 = j;
                dArray[n5] = dArray[n5] + this.heights[i][j];
                int n6 = j;
                dArray2[n6] = dArray2[n6] + this.errors[i][j];
            }
        }
        Histogram1D histogram1D = new Histogram1D(string, this.yAxis);
        histogram1D.setContents(nArray, dArray, dArray2);
        return histogram1D;
    }

    @Override
    public double meanX() {
        return this.meanX / this.sumWeight;
    }

    @Override
    public double meanY() {
        return this.meanY / this.sumWeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                this.entries[i][j] = 0;
                this.heights[i][j] = 0.0;
                this.errors[i][j] = 0.0;
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
    }

    @Override
    public double rmsX() {
        return Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    @Override
    public double rmsY() {
        return Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    void setContents(int[][] nArray, double[][] dArray, double[][] dArray2) {
        this.entries = nArray;
        this.heights = dArray;
        this.errors = dArray2;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                this.nEntry += nArray[i][j];
                this.sumWeight += dArray[i][j];
            }
        }
        this.sumWeightSquared = Double.NaN;
        this.meanX = Double.NaN;
        this.rmsX = Double.NaN;
        this.meanY = Double.NaN;
        this.rmsY = Double.NaN;
    }

    @Override
    public double sumAllBinHeights() {
        return this.sumWeight;
    }
}

