/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.ref;

import cern.hep.aida.ref.Histogram;
import colt.hep.aida.IAxis;
import colt.hep.aida.IHistogram1D;
import colt.hep.aida.IHistogram2D;

abstract class AbstractHistogram2D
extends Histogram
implements IHistogram2D {
    protected IAxis xAxis;
    protected IAxis yAxis;

    AbstractHistogram2D(String string) {
        super(string);
    }

    @Override
    public int allEntries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= -2) {
            int n3 = this.yAxis.bins();
            while (--n3 >= -2) {
                n += this.binEntries(n2, n3);
            }
        }
        return n;
    }

    @Override
    public int binEntriesX(int n) {
        return this.projectionX().binEntries(n);
    }

    @Override
    public int binEntriesY(int n) {
        return this.projectionY().binEntries(n);
    }

    @Override
    public double binHeightX(int n) {
        return this.projectionX().binHeight(n);
    }

    @Override
    public double binHeightY(int n) {
        return this.projectionY().binHeight(n);
    }

    @Override
    public int dimensions() {
        return 2;
    }

    @Override
    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                n += this.binEntries(i, j);
            }
        }
        return n;
    }

    @Override
    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    @Override
    public void fill(double d, double d2) {
        this.fill(d, d2, 1.0);
    }

    protected abstract IHistogram1D internalSliceX(String var1, int var2, int var3);

    protected abstract IHistogram1D internalSliceY(String var1, int var2, int var3);

    int mapX(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    int mapY(int n) {
        int n2 = this.yAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    @Override
    public int[] minMaxBins() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.xAxis.bins();
        while (--n5 >= 0) {
            int n6 = this.yAxis.bins();
            while (--n6 >= 0) {
                double d3 = this.binHeight(n5, n6);
                if (d3 < d) {
                    d = d3;
                    n = n5;
                    n2 = n6;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                n3 = n5;
                n4 = n6;
            }
        }
        int[] nArray = new int[]{n, n2, n3, n4};
        return nArray;
    }

    @Override
    public IHistogram1D projectionX() {
        String string = this.title() + " (projectionX)";
        return this.internalSliceX(string, this.mapY(-2), this.mapY(-1));
    }

    @Override
    public IHistogram1D projectionY() {
        String string = this.title() + " (projectionY)";
        return this.internalSliceY(string, this.mapX(-2), this.mapX(-1));
    }

    @Override
    public IHistogram1D sliceX(int n) {
        int n2 = this.mapY(n);
        String string = this.title() + " (sliceX [" + n + "])";
        return this.internalSliceX(string, n2, n2);
    }

    @Override
    public IHistogram1D sliceX(int n, int n2) {
        int n3 = this.mapY(n);
        int n4 = this.mapY(n2);
        String string = this.title() + " (sliceX [" + n + ":" + n2 + "])";
        return this.internalSliceX(string, n3, n4);
    }

    @Override
    public IHistogram1D sliceY(int n) {
        int n2 = this.mapX(n);
        String string = this.title() + " (sliceY [" + n + "])";
        return this.internalSliceY(string, n2, n2);
    }

    @Override
    public IHistogram1D sliceY(int n, int n2) {
        int n3 = this.mapX(n);
        int n4 = this.mapX(n2);
        String string = this.title() + " (slicey [" + n + ":" + n2 + "])";
        return this.internalSliceY(string, n3, n4);
    }

    @Override
    public double sumAllBinHeights() {
        double d = 0.0;
        int n = this.xAxis.bins();
        while (--n >= -2) {
            int n2 = this.yAxis.bins();
            while (--n2 >= -2) {
                d += this.binHeight(n, n2);
            }
        }
        return d;
    }

    @Override
    public double sumBinHeights() {
        double d = 0.0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                d += this.binHeight(i, j);
            }
        }
        return d;
    }

    @Override
    public double sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    @Override
    public IAxis xAxis() {
        return this.xAxis;
    }

    @Override
    public IAxis yAxis() {
        return this.yAxis;
    }
}

