/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.ref;

import cern.hep.aida.ref.Histogram;
import colt.hep.aida.IAxis;
import colt.hep.aida.IHistogram1D;

abstract class AbstractHistogram1D
extends Histogram
implements IHistogram1D {
    protected IAxis xAxis;

    AbstractHistogram1D(String string) {
        super(string);
    }

    @Override
    public int allEntries() {
        return this.entries() + this.extraEntries();
    }

    @Override
    public int dimensions() {
        return 1;
    }

    @Override
    public int entries() {
        int n = 0;
        int n2 = this.xAxis.bins();
        while (--n2 >= 0) {
            n += this.binEntries(n2);
        }
        return n;
    }

    @Override
    public int extraEntries() {
        return this.binEntries(-2) + this.binEntries(-1);
    }

    int map(int n) {
        int n2 = this.xAxis.bins() + 2;
        if (n >= n2) {
            throw new IllegalArgumentException("bin=" + n);
        }
        if (n >= 0) {
            return n + 1;
        }
        if (n == -2) {
            return 0;
        }
        if (n == -1) {
            return n2 - 1;
        }
        throw new IllegalArgumentException("bin=" + n);
    }

    @Override
    public int[] minMaxBins() {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = -1;
        int n2 = -1;
        int n3 = this.xAxis.bins();
        while (--n3 >= 0) {
            double d3 = this.binHeight(n3);
            if (d3 < d) {
                d = d3;
                n = n3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
            n2 = n3;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    @Override
    public double sumAllBinHeights() {
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    @Override
    public double sumBinHeights() {
        double d = 0.0;
        int n = this.xAxis.bins();
        while (--n >= 0) {
            d += this.binHeight(n);
        }
        return d;
    }

    @Override
    public double sumExtraBinHeights() {
        return this.binHeight(-2) + this.binHeight(-1);
    }

    @Override
    public IAxis xAxis() {
        return this.xAxis;
    }
}

