/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.bin;

import cern.colt.buffer.DoubleBuffer;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractDoubleIntMap;
import cern.colt.map.OpenDoubleIntHashMap;
import cern.hep.aida.bin.BinBinFunction1D;
import cern.hep.aida.bin.QuantileBin1D;
import cern.jet.random.Uniform;
import cern.jet.random.engine.RandomEngine;
import cern.jet.random.sampling.RandomSamplingAssistant;
import cern.jet.stat.Descriptive;

public class DynamicBin1D
extends QuantileBin1D {
    protected DoubleArrayList elements = null;
    protected DoubleArrayList sortedElements = null;
    protected boolean fixedOrder = false;
    protected boolean isSorted = true;
    protected boolean isIncrementalStatValid = true;
    protected boolean isSumOfInversionsValid = true;
    protected boolean isSumOfLogarithmsValid = true;

    public DynamicBin1D() {
        this.clear();
        this.elements = new DoubleArrayList();
        this.sortedElements = new DoubleArrayList(0);
        this.fixedOrder = false;
        this.hasSumOfLogarithms = true;
        this.hasSumOfInversions = true;
    }

    @Override
    public synchronized void add(double d) {
        this.elements.add(d);
        this.invalidateAll();
    }

    @Override
    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        this.elements.addAllOfFromTo(doubleArrayList, n, n2);
        this.invalidateAll();
    }

    public synchronized double aggregate(DoubleDoubleFunction doubleDoubleFunction, DoubleFunction doubleFunction) {
        int n = this.size();
        if (n == 0) {
            return Double.NaN;
        }
        double d = doubleFunction.apply(this.elements.getQuick(n - 1));
        int n2 = n - 1;
        while (--n2 >= 0) {
            d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.elements.getQuick(n2)));
        }
        return d;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.sortedElements != null) {
            this.sortedElements.clear();
        }
        this.validateAll();
    }

    @Override
    protected void clearAllMeasures() {
        super.clearAllMeasures();
    }

    @Override
    public synchronized Object clone() {
        DynamicBin1D dynamicBin1D = (DynamicBin1D)super.clone();
        if (this.elements != null) {
            dynamicBin1D.elements = dynamicBin1D.elements.copy();
        }
        if (this.sortedElements != null) {
            dynamicBin1D.sortedElements = dynamicBin1D.sortedElements.copy();
        }
        return dynamicBin1D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double correlation(DynamicBin1D dynamicBin1D) {
        DynamicBin1D dynamicBin1D2 = dynamicBin1D;
        synchronized (dynamicBin1D2) {
            return this.covariance(dynamicBin1D) / (this.standardDeviation() * dynamicBin1D.standardDeviation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double covariance(DynamicBin1D dynamicBin1D) {
        DynamicBin1D dynamicBin1D2 = dynamicBin1D;
        synchronized (dynamicBin1D2) {
            if (this.size() != dynamicBin1D.size()) {
                throw new IllegalArgumentException("both bins must have same size");
            }
            double d = 0.0;
            int n = this.size();
            while (--n >= 0) {
                d += this.elements.getQuick(n) * dynamicBin1D.elements.getQuick(n);
            }
            double d2 = (d - this.sum() * dynamicBin1D.sum() / (double)this.size()) / (double)this.size();
            return d2;
        }
    }

    public synchronized DoubleArrayList elements() {
        return this.elements_unsafe().copy();
    }

    protected synchronized DoubleArrayList elements_unsafe() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean equals(Object object) {
        if (!(object instanceof DynamicBin1D)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DynamicBin1D dynamicBin1D = (DynamicBin1D)object;
        double[] dArray = this.sortedElements_unsafe().elements();
        DynamicBin1D dynamicBin1D2 = dynamicBin1D;
        synchronized (dynamicBin1D2) {
            double[] dArray2 = dynamicBin1D.sortedElements_unsafe().elements();
            int n = this.size();
            return DynamicBin1D.includes(dArray, dArray2, 0, n, 0, n) && DynamicBin1D.includes(dArray2, dArray, 0, n, 0, n);
        }
    }

    private static boolean includes(double[] dArray, double[] dArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (dArray2[n3] < dArray[n]) {
                return false;
            }
            if (dArray[n] < dArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public synchronized void frequencies(DoubleArrayList doubleArrayList, IntArrayList intArrayList) {
        Descriptive.frequencies(this.sortedElements_unsafe(), doubleArrayList, intArrayList);
    }

    private synchronized AbstractDoubleIntMap frequencyMap() {
        OpenDoubleIntHashMap openDoubleIntHashMap = new OpenDoubleIntHashMap();
        int n = this.size();
        while (--n >= 0) {
            double d = this.elements.getQuick(n);
            ((AbstractDoubleIntMap)openDoubleIntHashMap).put(d, 1 + ((AbstractDoubleIntMap)openDoubleIntHashMap).get(d));
        }
        return openDoubleIntHashMap;
    }

    @Override
    public int getMaxOrderForSumOfPowers() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinOrderForSumOfPowers() {
        return Integer.MIN_VALUE;
    }

    protected void invalidateAll() {
        this.isSorted = false;
        this.isIncrementalStatValid = false;
        this.isSumOfInversionsValid = false;
        this.isSumOfLogarithmsValid = false;
    }

    @Override
    public synchronized boolean isRebinnable() {
        return true;
    }

    @Override
    public synchronized double max() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.max;
    }

    @Override
    public synchronized double min() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.min;
    }

    @Override
    public synchronized double moment(int n, double d) {
        return Descriptive.moment(this.elements, n, d);
    }

    @Override
    public synchronized double quantile(double d) {
        return Descriptive.quantile(this.sortedElements_unsafe(), d);
    }

    @Override
    public synchronized double quantileInverse(double d) {
        return Descriptive.quantileInverse(this.sortedElements_unsafe(), d);
    }

    @Override
    public DoubleArrayList quantiles(DoubleArrayList doubleArrayList) {
        return Descriptive.quantiles(this.sortedElements_unsafe(), doubleArrayList);
    }

    public synchronized boolean removeAllOf(DoubleArrayList doubleArrayList) {
        boolean bl = this.elements.removeAll(doubleArrayList);
        if (bl) {
            this.clearAllMeasures();
            this.invalidateAll();
            this.size = 0;
            if (this.fixedOrder) {
                this.sortedElements.removeAll(doubleArrayList);
                this.isSorted = true;
            }
        }
        return bl;
    }

    public synchronized void sample(int n, boolean bl, RandomEngine randomEngine, DoubleBuffer doubleBuffer) {
        if (randomEngine == null) {
            randomEngine = Uniform.makeDefaultGenerator();
        }
        doubleBuffer.clear();
        if (!bl) {
            if (n > this.size()) {
                throw new IllegalArgumentException("n must be less than or equal to size()");
            }
            RandomSamplingAssistant randomSamplingAssistant = new RandomSamplingAssistant(n, this.size(), randomEngine);
            int n2 = n;
            while (--n2 >= 0) {
                if (!randomSamplingAssistant.sampleNextElement()) continue;
                doubleBuffer.add(this.elements.getQuick(n2));
            }
        } else {
            Uniform uniform = new Uniform(randomEngine);
            int n3 = this.size();
            int n4 = n;
            while (--n4 >= 0) {
                doubleBuffer.add(this.elements.getQuick(uniform.nextIntFromTo(0, n3 - 1)));
            }
            doubleBuffer.flush();
        }
    }

    public synchronized DynamicBin1D sampleBootstrap(DynamicBin1D dynamicBin1D, int n, RandomEngine randomEngine, BinBinFunction1D binBinFunction1D) {
        if (randomEngine == null) {
            randomEngine = Uniform.makeDefaultGenerator();
        }
        int n2 = 1000;
        int n3 = this.size();
        int n4 = dynamicBin1D.size();
        DynamicBin1D dynamicBin1D2 = new DynamicBin1D();
        DoubleBuffer doubleBuffer = dynamicBin1D2.buffered(Math.min(n2, n3));
        DynamicBin1D dynamicBin1D3 = new DynamicBin1D();
        DoubleBuffer doubleBuffer2 = dynamicBin1D3.buffered(Math.min(n2, n4));
        DynamicBin1D dynamicBin1D4 = new DynamicBin1D();
        DoubleBuffer doubleBuffer3 = dynamicBin1D4.buffered(Math.min(n2, n));
        int n5 = n;
        while (--n5 >= 0) {
            dynamicBin1D2.clear();
            dynamicBin1D3.clear();
            this.sample(n3, true, randomEngine, doubleBuffer);
            dynamicBin1D.sample(n4, true, randomEngine, doubleBuffer2);
            doubleBuffer3.add(binBinFunction1D.apply(dynamicBin1D2, dynamicBin1D3));
        }
        doubleBuffer3.flush();
        return dynamicBin1D4;
    }

    public void setFixedOrder(boolean bl) {
        this.fixedOrder = bl;
    }

    @Override
    public synchronized int size() {
        return this.elements.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            if (this.fixedOrder) {
                this.sortedElements.clear();
                this.sortedElements.addAllOfFromTo(this.elements, 0, this.elements.size() - 1);
                this.sortedElements.sort();
            } else {
                this.updateIncrementalStats();
                this.invalidateAll();
                this.elements.sort();
                this.isIncrementalStatValid = true;
            }
            this.isSorted = true;
        }
    }

    public synchronized DoubleArrayList sortedElements() {
        return this.sortedElements_unsafe().copy();
    }

    protected synchronized DoubleArrayList sortedElements_unsafe() {
        this.sort();
        if (this.fixedOrder) {
            return this.sortedElements;
        }
        return this.elements;
    }

    public synchronized void standardize(double d, double d2) {
        Descriptive.standardize(this.elements, d, d2);
        this.clearAllMeasures();
        this.invalidateAll();
        this.size = 0;
    }

    @Override
    public synchronized double sum() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum;
    }

    @Override
    public synchronized double sumOfInversions() {
        if (!this.isSumOfInversionsValid) {
            this.updateSumOfInversions();
        }
        return this.sumOfInversions;
    }

    @Override
    public synchronized double sumOfLogarithms() {
        if (!this.isSumOfLogarithmsValid) {
            this.updateSumOfLogarithms();
        }
        return this.sumOfLogarithms;
    }

    @Override
    public synchronized double sumOfPowers(int n) {
        if (n >= -1 && n <= 2) {
            return super.sumOfPowers(n);
        }
        return Descriptive.sumOfPowers(this.elements, n);
    }

    @Override
    public synchronized double sumOfSquares() {
        if (!this.isIncrementalStatValid) {
            this.updateIncrementalStats();
        }
        return this.sum_xx;
    }

    @Override
    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        IntArrayList intArrayList = new IntArrayList();
        this.frequencies(doubleArrayList, intArrayList);
        if (doubleArrayList.size() < 100) {
            stringBuffer.append("Distinct elements: " + doubleArrayList + "\n");
            stringBuffer.append("Frequencies: " + intArrayList + "\n");
        } else {
            stringBuffer.append("Distinct elements & frequencies not printed (too many).");
        }
        return stringBuffer.toString();
    }

    public synchronized void trim(int n, int n2) {
        DoubleArrayList doubleArrayList = this.sortedElements();
        this.clear();
        this.addAllOfFromTo(doubleArrayList, n, doubleArrayList.size() - 1 - n2);
    }

    public synchronized double trimmedMean(int n, int n2) {
        return Descriptive.trimmedMean(this.sortedElements_unsafe(), this.mean(), n, n2);
    }

    @Override
    public synchronized void trimToSize() {
        this.elements.trimToSize();
        this.sortedElements.clear();
        this.sortedElements.trimToSize();
        if (this.fixedOrder) {
            this.isSorted = false;
        }
    }

    protected void updateIncrementalStats() {
        double[] dArray = new double[]{this.min, this.max, this.sum, this.sum_xx};
        Descriptive.incrementalUpdate(this.elements, this.size, this.elements.size() - 1, dArray);
        this.min = dArray[0];
        this.max = dArray[1];
        this.sum = dArray[2];
        this.sum_xx = dArray[3];
        this.isIncrementalStatValid = true;
        this.size = this.elements.size();
    }

    protected void updateSumOfInversions() {
        this.sumOfInversions = Descriptive.sumOfInversions(this.elements, 0, this.size() - 1);
        this.isSumOfInversionsValid = true;
    }

    protected void updateSumOfLogarithms() {
        this.sumOfLogarithms = Descriptive.sumOfLogarithms(this.elements, 0, this.size() - 1);
        this.isSumOfLogarithmsValid = true;
    }

    protected void validateAll() {
        this.isSorted = true;
        this.isIncrementalStatValid = true;
        this.isSumOfInversionsValid = true;
        this.isSumOfLogarithmsValid = true;
    }
}

