/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.map.OpenIntDoubleHashMap;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SelectedSparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

public class SparseDoubleMatrix1D
extends DoubleMatrix1D {
    protected AbstractIntDoubleMap elements;

    public SparseDoubleMatrix1D(double[] dArray) {
        this(dArray.length);
        this.assign(dArray);
    }

    public SparseDoubleMatrix1D(int n) {
        this(n, n / 1000, 0.2, 0.5);
    }

    public SparseDoubleMatrix1D(int n, int n2, double d, double d2) {
        this.setUp(n);
        this.elements = new OpenIntDoubleHashMap(n2, d, d2);
    }

    protected SparseDoubleMatrix1D(int n, AbstractIntDoubleMap abstractIntDoubleMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = abstractIntDoubleMap;
        this.isNoView = false;
    }

    @Override
    public DoubleMatrix1D assign(double d) {
        if (this.isNoView && d == 0.0) {
            this.elements.clear();
        } else {
            super.assign(d);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    @Override
    public double getQuick(int n) {
        return this.elements.get(this.zero + n * this.stride);
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D selectedSparseDoubleMatrix1D = (SelectedSparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedSparseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = (SparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == sparseDoubleMatrix1D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n) {
        return this.zero + n * this.stride;
    }

    @Override
    public DoubleMatrix1D like(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    @Override
    public DoubleMatrix2D like2D(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    @Override
    public void setQuick(int n, double d) {
        int n2 = this.zero + n * this.stride;
        if (d == 0.0) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, d);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDoubleMatrix1D(this.elements, nArray);
    }
}

