/*
 * Decompiled with CFR 0.152.
 */
package cern.colt;

import cern.colt.Arrays;
import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Sorting;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;

class GenericSortingTest {
    protected GenericSortingTest() {
    }

    public static void demo1() {
        final int[] nArray = new int[]{3, 2, 1};
        final double[] dArray = new double[]{3.0, 2.0, 1.0};
        final double[] dArray2 = new double[]{6.0, 7.0, 8.0};
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
                double d2 = dArray2[n];
                dArray2[n] = dArray2[n2];
                dArray2[n2] = d2;
            }
        };
        IntComparator intComparator = new IntComparator(){

            @Override
            public int compare(int n, int n2) {
                return nArray[n] == nArray[n2] ? 0 : (nArray[n] < nArray[n2] ? -1 : 1);
            }
        };
        System.out.println("before:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        int n = 0;
        int n2 = nArray.length;
        GenericSorting.quickSort(n, n2, intComparator, swapper);
        System.out.println("after:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        System.out.println("\n\n");
    }

    public static void demo2() {
        final int[] nArray = new int[]{6, 7, 8, 9};
        final double[] dArray = new double[]{3.0, 2.0, 1.0, 3.0};
        final double[] dArray2 = new double[]{5.0, 4.0, 4.0, 1.0};
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                double d = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d;
                double d2 = dArray2[n];
                dArray2[n] = dArray2[n2];
                dArray2[n2] = d2;
            }
        };
        IntComparator intComparator = new IntComparator(){

            @Override
            public int compare(int n, int n2) {
                if (dArray[n] == dArray[n2]) {
                    return dArray2[n] == dArray2[n2] ? 0 : (dArray2[n] < dArray2[n2] ? -1 : 1);
                }
                return dArray[n] < dArray[n2] ? -1 : 1;
            }
        };
        System.out.println("before:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        int n = 0;
        int n2 = nArray.length;
        GenericSorting.quickSort(n, n2, intComparator, swapper);
        System.out.println("after:");
        System.out.println("X=" + Arrays.toString(nArray));
        System.out.println("Y=" + Arrays.toString(dArray));
        System.out.println("Z=" + Arrays.toString(dArray2));
        System.out.println("\n\n");
    }

    public static void testRandomly(int n) {
        MersenneTwister mersenneTwister = new MersenneTwister();
        Uniform uniform = new Uniform(mersenneTwister);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = 50;
            int n5 = 2 * n4;
            int n6 = uniform.nextIntFromTo(1, n4);
            if (n6 == 0) {
                n3 = 0;
                n2 = -1;
            } else {
                n3 = uniform.nextIntFromTo(0, n6 - 1);
                n2 = uniform.nextIntFromTo(Math.min(n3, n6 - 1), n6 - 1);
            }
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n6, n6);
            DoubleMatrix2D doubleMatrix2D = denseDoubleMatrix2D.viewPart(n3, n3, n6 - n2, n6 - n2);
            int n7 = uniform.nextIntFromTo(n6 / 2, 2 * n6);
            int n8 = uniform.nextIntFromTo(n7, 2 * n6);
            for (int j = 0; j < n6; ++j) {
                for (int k = 0; k < n6; ++k) {
                    denseDoubleMatrix2D.set(j, k, uniform.nextIntFromTo(n7, n8));
                }
            }
            DoubleMatrix2D doubleMatrix2D2 = denseDoubleMatrix2D.copy();
            DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2.viewPart(n3, n3, n6 - n2, n6 - n2);
            int n9 = 0;
            DoubleMatrix2D doubleMatrix2D4 = Sorting.quickSort.sort(doubleMatrix2D, n9);
            DoubleMatrix2D doubleMatrix2D5 = Sorting.mergeSort.sort(doubleMatrix2D3, n9);
            if (doubleMatrix2D4.viewColumn(n9).equals(doubleMatrix2D5.viewColumn(n9))) continue;
            throw new InternalError();
        }
        System.out.println("All tests passed. No bug detected.");
    }
}

