/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.oneloopdiv;

import cc.redberry.core.indices.IndicesUtils;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductBuilder;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.StructureOfContractionsHashed;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.TensorContraction;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.utils.ArraysUtils;
import cc.redberry.core.utils.IntArrayList;
import java.util.Arrays;

final class SqrSubs
implements Transformation {
    private int name;

    public SqrSubs(SimpleTensor st) {
        if (st.getIndices().size() != 1) {
            throw new IllegalArgumentException();
        }
        this.name = st.getName();
    }

    @Override
    public Tensor transform(Tensor tensor) {
        if (!(tensor instanceof Product)) {
            return tensor;
        }
        Product product = (Product)tensor;
        ProductContent content = product.getContent();
        StructureOfContractionsHashed cs = content.getStructureOfContractionsHashed();
        short si = content.getStretchIndexByHash(this.name);
        if (si == -1) {
            return tensor;
        }
        TensorContraction contraction = new TensorContraction(si, new long[]{(long)si << 16});
        short[] sIndices = content.getStretchIds();
        int index = Arrays.binarySearch(sIndices, si);
        while (index >= 0 && sIndices[index--] == si) {
        }
        ++index;
        IntArrayList list = new IntArrayList();
        do {
            int indexName;
            SimpleTensor st;
            Tensor t;
            if (!((t = content.get(index)) instanceof SimpleTensor) || (st = (SimpleTensor)t).getName() != this.name || !cs.get(index).equals(contraction) || ((indexName = st.getIndices().get(0)) & Integer.MIN_VALUE) != 0) continue;
            list.add(indexName);
        } while (index < sIndices.length - 1 && sIndices[++index] == si);
        int[] indices = list.toArray();
        if (indices.length == 0) {
            return tensor;
        }
        Arrays.sort(indices);
        IntArrayList toRemvoe = new IntArrayList();
        int size = content.size();
        for (index = 0; index < size; ++index) {
            SimpleTensor st;
            Tensor current = content.get(index);
            if (!(current instanceof SimpleTensor) || (st = (SimpleTensor)current).getName() != this.name || Arrays.binarySearch(indices, IndicesUtils.getNameWithType(st.getIndices().get(0))) < 0) continue;
            toRemvoe.add(index);
        }
        if (toRemvoe.size() == 0) {
            return tensor;
        }
        Tensor indexless = product.getIndexlessSubProduct();
        ProductBuilder pb = new ProductBuilder();
        pb.put(indexless);
        for (int i = size - 1; i >= 0; --i) {
            if (ArraysUtils.binarySearch(toRemvoe, i) >= 0) continue;
            pb.put(content.get(i));
        }
        return pb.build();
    }
}

