/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.oneloopdiv;

import cc.redberry.core.indices.IndicesBuilder;
import cc.redberry.core.number.Complex;
import cc.redberry.core.tensor.ApplyIndexMapping;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.Power;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Sum;
import cc.redberry.core.tensor.SumBuilder;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.tensor.iterator.FromChildToParentIterator;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.expand.ExpandTransformation;
import cc.redberry.core.utils.TensorUtils;
import java.util.ArrayList;
import org.apache.commons.math3.util.ArithmeticUtils;

public final class Averaging
implements Transformation {
    private final SimpleTensor const_n;

    public Averaging(SimpleTensor const_n) {
        this.const_n = const_n;
    }

    private static Tensor average(int[] indices) {
        if (indices.length == 0) {
            return Complex.ONE;
        }
        if (indices.length == 2) {
            return Tensors.createMetricOrKronecker(indices[0], indices[1]);
        }
        SumBuilder sb = new SumBuilder();
        for (int i = 1; i < indices.length; ++i) {
            int[] suffix = new int[indices.length - 2];
            System.arraycopy(indices, 1, suffix, 0, i - 1);
            System.arraycopy(indices, i + 1, suffix, i - 1, indices.length - i - 1);
            sb.put(Tensors.multiply(Tensors.createMetricOrKronecker(indices[0], indices[i]), Averaging.average(suffix)));
        }
        return sb.build();
    }

    @Override
    public Tensor transform(Tensor tensor) {
        if (tensor instanceof Sum || tensor instanceof Expression) {
            Tensor[] newSumElements = new Tensor[tensor.size()];
            boolean needRebuild = false;
            for (int i = tensor.size() - 1; i >= 0; --i) {
                Tensor tempResult;
                Tensor tensorCurrent = tensor.get(i);
                if (tensorCurrent != (tempResult = this.transform(tensorCurrent))) {
                    needRebuild = true;
                }
                newSumElements[i] = tempResult;
            }
            if (needRebuild) {
                return tensor.getFactory().create(newSumElements);
            }
            return tensor;
        }
        if (tensor instanceof Product) {
            int count = 0;
            IndicesBuilder ib = new IndicesBuilder();
            ArrayList<Tensor> newProductElements = new ArrayList<Tensor>();
            for (int i = tensor.size() - 1; i >= 0; --i) {
                Tensor current = tensor.get(i);
                if (this.isN(current)) {
                    ib.append(current);
                    ++count;
                    continue;
                }
                if (TensorUtils.isScalar(current)) {
                    Tensor temp;
                    FromChildToParentIterator iterator = new FromChildToParentIterator(current);
                    boolean flag = false;
                    while ((temp = iterator.next()) != null) {
                        if (!this.isN(temp)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        newProductElements.add(current);
                        continue;
                    }
                    if (!(current instanceof Power) || !TensorUtils.isInteger(current.get(1)) || ((Complex)current.get(1)).intValue() != 2) {
                        throw new IllegalArgumentException();
                    }
                    Tensor[] bases = new Tensor[]{current.get(0), current.get(0)};
                    bases[1] = ApplyIndexMapping.renameDummy(bases[1], TensorUtils.getAllIndicesNamesT(tensor).toArray());
                    flag = false;
                    for (Tensor base : bases) {
                        for (Tensor t : base) {
                            if (this.isN(t)) {
                                ib.append(t);
                                ++count;
                                flag = true;
                                continue;
                            }
                            newProductElements.add(t);
                        }
                    }
                    if (flag) continue;
                    throw new IllegalArgumentException("Expand first");
                }
                newProductElements.add(current);
            }
            if (count == 0) {
                return tensor;
            }
            if (count % 2 != 0) {
                return Complex.ZERO;
            }
            Tensor result = Averaging.average(ib.getIndices().getAllIndices().copy());
            long factor = ArithmeticUtils.pow((long)2L, (int)(count /= 2)) * ArithmeticUtils.factorial((int)(count + 1));
            Complex number = new Complex(factor).reciprocal();
            result = ExpandTransformation.expand(result);
            newProductElements.add(number);
            newProductElements.add(result);
            return Tensors.multiply(newProductElements.toArray(new Tensor[newProductElements.size()]));
        }
        if (tensor instanceof Power) {
            Tensor nBase = this.transform(tensor.get(0));
            if (nBase == tensor.get(0)) {
                return tensor;
            }
            return Tensors.pow(nBase, tensor.get(1));
        }
        return tensor;
    }

    private boolean isN(Tensor t) {
        return t instanceof SimpleTensor && ((SimpleTensor)t).getName() == this.const_n.getName();
    }
}

