/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.physics.feyncalc;

import cc.redberry.core.context.CC;
import cc.redberry.core.context.NameAndStructureOfIndices;
import cc.redberry.core.context.OutputFormat;
import cc.redberry.core.indices.IndexType;
import cc.redberry.core.number.Complex;
import cc.redberry.core.parser.ParseToken;
import cc.redberry.core.parser.Parser;
import cc.redberry.core.parser.preprocessor.ChangeIndicesTypesAndTensorNames;
import cc.redberry.core.parser.preprocessor.TypesAndNamesTransformer;
import cc.redberry.core.tensor.Expression;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.Tensors;
import cc.redberry.core.transformations.EliminateMetricsTransformation;
import cc.redberry.core.transformations.Transformation;
import cc.redberry.core.transformations.TransformationCollection;
import cc.redberry.physics.feyncalc.TraceUtils;
import java.util.ArrayList;

public class UnitarySimplifyTransformation
implements Transformation {
    final Transformation unitarySimplifications;
    private static final Parser parser = CC.current().getParseManager().getParser();
    private static final ParseToken contraction1Token = parser.parse("T_a^a'_b'*T^ab'_c' = (N**2-1)/(2*N)*d^a'_c'");
    private static final ParseToken contraction2Token = parser.parse("T_a^a'_b'*T_b^b'_c'*T^ac'_d' = -T_b^a'_d'/(2*N)");
    private static final ParseToken symmetricCombinationToken = parser.parse("D_apq*D_b^pq = (N**2 - 4)/N * g_ab");
    private static final ParseToken symmetricTraceToken = parser.parse("D_a^ab = 0");
    private static final ParseToken aSymmetricCombinationToken;
    private static final ParseToken aSymmetricTraceToken;
    private static final ParseToken symmetrySimplificationToken;
    private static final ParseToken numberOfGeneratorsToken;
    private static final ParseToken dimensionToken;
    private static final ParseToken[] unitarySimplificationsTokens;

    public UnitarySimplifyTransformation(final SimpleTensor unitaryMatrix, final SimpleTensor structureConstant, final SimpleTensor symmetricConstant, final Tensor dimension) {
        TraceUtils.checkUnitaryInput(unitaryMatrix, structureConstant, symmetricConstant, dimension);
        final IndexType[] types = TraceUtils.extractTypesFromMatrix(unitaryMatrix);
        ChangeIndicesTypesAndTensorNames tokenTransformer = new ChangeIndicesTypesAndTensorNames(new TypesAndNamesTransformer(){

            @Override
            public IndexType newType(IndexType oldType, NameAndStructureOfIndices old) {
                if (oldType == IndexType.LatinLower) {
                    return types[0];
                }
                if (oldType == IndexType.Matrix1) {
                    return types[1];
                }
                return oldType;
            }

            @Override
            public String newName(NameAndStructureOfIndices old) {
                switch (old.getName()) {
                    case "T": {
                        return unitaryMatrix.getStringName();
                    }
                    case "F": {
                        return structureConstant.getStringName();
                    }
                    case "D": {
                        return symmetricConstant.getStringName();
                    }
                    case "N": {
                        if (dimension instanceof Complex) break;
                        return dimension.toString(OutputFormat.Redberry);
                    }
                }
                return old.getName();
            }
        });
        ArrayList<Transformation> unitarySimplifications = new ArrayList<Transformation>();
        if (dimension instanceof Complex) {
            Expression nSub = Tensors.parseExpression("N = " + dimension);
            for (ParseToken substitution : unitarySimplificationsTokens) {
                unitarySimplifications.add((Transformation)((Object)nSub.transform(tokenTransformer.transform(substitution).toTensor())));
            }
        } else {
            for (ParseToken substitution : unitarySimplificationsTokens) {
                unitarySimplifications.add((Transformation)((Object)tokenTransformer.transform(substitution).toTensor()));
            }
        }
        ArrayList<Transformation> simplifications = new ArrayList<Transformation>();
        simplifications.add(EliminateMetricsTransformation.ELIMINATE_METRICS);
        simplifications.addAll(unitarySimplifications);
        this.unitarySimplifications = new TransformationCollection(simplifications);
    }

    UnitarySimplifyTransformation(Tensor dimension, ChangeIndicesTypesAndTensorNames tokenTransformer) {
        ArrayList<Transformation> unitarySimplifications = new ArrayList<Transformation>();
        if (dimension instanceof Complex) {
            Expression nSub = Tensors.parseExpression("N = " + dimension);
            for (ParseToken substitution : unitarySimplificationsTokens) {
                unitarySimplifications.add((Transformation)((Object)nSub.transform(tokenTransformer.transform(substitution).toTensor())));
            }
        } else {
            for (ParseToken substitution : unitarySimplificationsTokens) {
                unitarySimplifications.add((Transformation)((Object)tokenTransformer.transform(substitution).toTensor()));
            }
        }
        ArrayList<Transformation> simplifications = new ArrayList<Transformation>();
        simplifications.add(EliminateMetricsTransformation.ELIMINATE_METRICS);
        simplifications.addAll(unitarySimplifications);
        this.unitarySimplifications = new TransformationCollection(simplifications);
    }

    @Override
    public Tensor transform(Tensor t) {
        Tensor old = t;
        while ((t = this.unitarySimplifications.transform(old)) != old) {
            old = t;
        }
        return t;
    }

    static {
        aSymmetricTraceToken = parser.parse("F_a^ab = 0");
        aSymmetricCombinationToken = parser.parse("F_apq*F_b^pq = N * g_ab");
        symmetrySimplificationToken = parser.parse("F_apq*D_b^pq = 0");
        numberOfGeneratorsToken = parser.parse("d^a_a = N**2-1");
        dimensionToken = parser.parse("d^a'_a' = N");
        unitarySimplificationsTokens = new ParseToken[]{contraction1Token, contraction2Token, symmetricCombinationToken, aSymmetricCombinationToken, symmetricTraceToken, aSymmetricTraceToken, symmetrySimplificationToken, numberOfGeneratorsToken, dimensionToken};
    }
}

