/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.indices.Indices;
import cc.redberry.core.indices.SimpleIndices;
import cc.redberry.core.tensor.Product;
import cc.redberry.core.tensor.ProductContent;
import cc.redberry.core.tensor.SimpleTensor;
import cc.redberry.core.tensor.Tensor;
import cc.redberry.core.tensor.functions.ScalarFunction;
import cc.redberry.core.utils.HashFunctions;
import java.util.Arrays;

public final class TensorHashCalculator {
    private TensorHashCalculator() {
    }

    private static int _hashWithIndices(Tensor tensor, int[] indices) {
        if (tensor instanceof SimpleTensor) {
            SimpleIndices si = ((SimpleTensor)tensor).getIndices();
            short[] sInds = si.getPositionsInOrbits();
            int hash = tensor.hashCode();
            for (int i = 0; i < si.size(); ++i) {
                int pos = Arrays.binarySearch(indices, si.get(i));
                if (pos < 0) continue;
                hash += HashFunctions.JenkinWang32shift(sInds[i]) ^ HashFunctions.JenkinWang32shift(pos) * 37;
            }
            return HashFunctions.JenkinWang32shift(hash);
        }
        if (tensor instanceof ScalarFunction) {
            return tensor.hashCode();
        }
        int hash = tensor.hashCode();
        if (tensor instanceof Product) {
            ProductContent pc = ((Product)tensor).getContent();
            for (int i = pc.size() - 1; i >= 0; --i) {
                hash += HashFunctions.JenkinWang32shift(pc.getStretchId(i)) * TensorHashCalculator._hashWithIndices(pc.get(i), indices);
            }
            return hash;
        }
        for (Tensor t : tensor) {
            hash ^= TensorHashCalculator._hashWithIndices(t, indices);
        }
        return hash;
    }

    public static int hashWithIndices(Tensor tensor, int[] indices) {
        if (indices.length == 0) {
            return tensor.hashCode();
        }
        Arrays.sort(indices);
        return TensorHashCalculator._hashWithIndices(tensor, indices);
    }

    public static int hashWithIndices(Tensor tensor, Indices indices) {
        return TensorHashCalculator.hashWithIndices(tensor, indices.getAllIndices().copy());
    }

    public static int hashWithIndices(Tensor tensor) {
        return TensorHashCalculator.hashWithIndices(tensor, tensor.getIndices().getFree());
    }

    public static int nontopologicalHash(Tensor tensor) {
        if (tensor.getClass() == SimpleTensor.class) {
            return tensor.hashCode();
        }
        int hashCode = tensor.getClass().hashCode();
        for (Tensor t : tensor) {
            hashCode = 13 * hashCode + TensorHashCalculator.nontopologicalHash(t);
        }
        return hashCode;
    }
}

