/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.core.utils;

import cc.redberry.core.tensor.Tensor;

public interface Indicator<E> {
    public static final Indicator TRUE_INDICATOR = new Indicator(){

        public boolean is(Object object) {
            return true;
        }
    };
    public static final Indicator FALSE_INDICATOR = new Indicator(){

        public boolean is(Object object) {
            return false;
        }
    };

    public boolean is(E var1);

    public static class Utils {
        @SafeVarargs
        public static <T> Indicator<T> and(final Indicator<T> ... indicators) {
            return new Indicator<T>(){

                @Override
                public boolean is(T object) {
                    for (Indicator indicator : indicators) {
                        if (indicator.is(object)) continue;
                        return false;
                    }
                    return true;
                }
            };
        }

        @SafeVarargs
        public static <T> Indicator<T> or(final Indicator<T> ... indicators) {
            return new Indicator<T>(){

                @Override
                public boolean is(T object) {
                    for (Indicator indicator : indicators) {
                        if (!indicator.is(object)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public static <T> Indicator<T> not(final Indicator<T> indicator) {
            return new Indicator<T>(){

                @Override
                public boolean is(T object) {
                    return !indicator.is(object);
                }
            };
        }

        public static Indicator<Tensor> classIndicator(final Class<? extends Tensor> clazz) {
            return new Indicator<Tensor>(){

                @Override
                public boolean is(Tensor object) {
                    return clazz == object.getClass();
                }
            };
        }

        public static <T extends Iterable<T>> Indicator<T> iterativeIndicator(final Indicator<T> indicator) {
            return new Indicator<T>(){

                @Override
                public boolean is(T object) {
                    if (indicator.is(object)) {
                        return true;
                    }
                    for (Iterable t : object) {
                        if (!indicator.is(t)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

